/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class ListQuestion
extends Question {
    private final EndQuestion end;
    private final Vector bodies;
    private int value;
    private static final ResourceBundle i18n = Interview.i18n;

    protected ListQuestion(Interview interview, String tag) {
        super(interview, tag);
        if (this instanceof EndQuestion) {
            this.end = (EndQuestion)this;
            this.bodies = null;
        } else {
            this.end = new EndQuestion(interview, tag, this);
            this.bodies = new Vector();
        }
    }

    public abstract Body createBody(int var1);

    public final boolean isEnd() {
        return this instanceof EndQuestion;
    }

    public ListQuestion getOther() {
        return this.end;
    }

    public Body getSelectedBody() {
        if (this.value >= 0 && this.value < this.bodies.size()) {
            return (Body)this.bodies.elementAt(this.value);
        }
        return null;
    }

    public int getValue() {
        return this.value;
    }

    public int getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.value);
    }

    public void setValue(int newValue) {
        int oldValue = this.value;
        this.value = newValue;
        if (this.normalizeValue(this.value) != this.normalizeValue(oldValue)) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    private int normalizeValue(int value) {
        return value >= 0 && value < this.bodies.size() ? value : -1;
    }

    @Override
    public void setValue(String s) {
        try {
            if (s != null) {
                this.setValue(Integer.parseInt(s));
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setValue(-1);
    }

    @Override
    public boolean isValueValid() {
        return true;
    }

    @Override
    public boolean isValueAlwaysValid() {
        return false;
    }

    @Override
    public void clear() {
        this.setValue(Integer.MIN_VALUE);
        this.bodies.setSize(0);
    }

    public String getEndSummary() {
        return this.end.getDefaultSummary();
    }

    public String getEndText() {
        return this.end.getDefaultText();
    }

    public Object[] getEndTextArgs() {
        return this.end.getDefaultTextArgs();
    }

    @Override
    protected void load(Map data) {
        String v;
        this.bodies.setSize(0);
        String c = (String)data.get(this.tag + ".count");
        if (c != null && c.length() > 0) {
            try {
                int n = Integer.parseInt(c);
                for (int i = 0; i < n; ++i) {
                    this.bodies.add(this.createBody(i));
                }
            }
            catch (NumberFormatException n) {
                // empty catch block
            }
        }
        if ((v = (String)data.get(this.tag + ".curr")) == null || v.length() == 0) {
            this.value = 0;
        } else {
            try {
                this.value = Integer.parseInt(v);
            }
            catch (NumberFormatException ignore) {
                this.value = 0;
            }
        }
    }

    @Override
    protected void save(Map data) {
        data.put(this.tag + ".count", String.valueOf(this.bodies.size()));
        data.put(this.tag + ".curr", String.valueOf(this.value));
    }

    public Body[] getBodies() {
        Object[] b = new Body[this.bodies.size()];
        this.bodies.copyInto(b);
        return b;
    }

    public int getBodyCount() {
        return this.bodies == null ? 0 : this.bodies.size();
    }

    public Body getBody(int index) {
        return (Body)this.bodies.elementAt(index);
    }

    public void setBodies(Body[] newBodies, int newValue) {
        Body oldSelectedBody = this.getSelectedBody();
        int oldIncompleteCount = this.getIncompleteBodyCount();
        boolean edited = false;
        if (newBodies.length != this.bodies.size()) {
            this.bodies.setSize(newBodies.length);
            edited = true;
        }
        for (int i = 0; i < newBodies.length; ++i) {
            Body b = newBodies[i];
            if (b == this.bodies.elementAt(i)) continue;
            b.setIndex(i);
            this.bodies.setElementAt(b, i);
            edited = true;
        }
        this.value = newValue;
        Body newSelectedBody = this.getSelectedBody();
        int newIncompleteCount = this.getIncompleteBodyCount();
        if (newSelectedBody != oldSelectedBody || oldIncompleteCount == 0 != (newIncompleteCount == 0)) {
            this.interview.updatePath(this);
        }
        this.interview.setEdited(edited);
    }

    public int getIncompleteBodyCount() {
        int count = 0;
        for (int i = 0; i < this.bodies.size(); ++i) {
            Body b = (Body)this.bodies.elementAt(i);
            if (b.isInterviewFinishable()) continue;
            ++count;
        }
        return count;
    }

    private static class EndQuestion
    extends ListQuestion {
        private ListQuestion head;

        EndQuestion(Interview interview, String tag, ListQuestion head) {
            super(interview, tag + ".end");
            this.head = head;
        }

        @Override
        public Question getNext() {
            boolean allBodiesFinishable = true;
            for (int i = 0; i < this.head.getBodyCount(); ++i) {
                Body b = this.head.getBody(i);
                if (b.isInterviewFinishable()) continue;
                allBodiesFinishable = false;
                break;
            }
            return allBodiesFinishable ? this.head.getNext() : null;
        }

        @Override
        public String getSummary() {
            return this.head.getEndSummary();
        }

        String getDefaultSummary() {
            return super.getSummary();
        }

        @Override
        public String getText() {
            return this.head.getEndText();
        }

        String getDefaultText() {
            return super.getText();
        }

        @Override
        public Object[] getTextArgs() {
            return this.head.getEndTextArgs();
        }

        Object[] getDefaultTextArgs() {
            return super.getTextArgs();
        }

        @Override
        public int getValue() {
            return this.head.getValue();
        }

        @Override
        public String getStringValue() {
            return this.head.getStringValue();
        }

        @Override
        public void setValue(int value) {
            this.head.setValue(value);
        }

        @Override
        public void setValue(String s) {
            this.head.setValue(s);
        }

        @Override
        public Body getSelectedBody() {
            return this.head.getSelectedBody();
        }

        @Override
        public Body createBody(int index) {
            return this.head.createBody(index);
        }

        @Override
        public ListQuestion getOther() {
            return this.head;
        }

        @Override
        public void clear() {
            this.head.clear();
        }

        @Override
        protected void load(Map data) {
        }

        @Override
        protected void save(Map data) {
        }

        @Override
        public Body[] getBodies() {
            return this.head.getBodies();
        }

        @Override
        public int getBodyCount() {
            return this.head.getBodyCount();
        }

        @Override
        public Body getBody(int index) {
            return this.head.getBody(index);
        }

        @Override
        public void setBodies(Body[] newBodies, int newValue) {
            this.head.setBodies(newBodies, newValue);
        }

        @Override
        public int getIncompleteBodyCount() {
            return this.head.getIncompleteBodyCount();
        }
    }

    public static abstract class Body
    extends Interview {
        private ListQuestion question;
        private int index;
        private String defaultSummary;

        protected Body(ListQuestion question, int index) {
            super(question.getInterview(), question.getBaseTag() + "." + index);
            this.question = question;
            this.index = index;
        }

        public abstract String getSummary();

        public int getIndex() {
            return this.index;
        }

        void setIndex(int newIndex) {
            if (newIndex != this.index) {
                this.index = newIndex;
                this.setBaseTag(this.question.getBaseTag() + "." + this.index);
            }
        }

        public String getDefaultSummary() {
            if (this.defaultSummary == null) {
                Vector bodies = this.question.bodies;
                for (int i = 0; i < bodies.size(); ++i) {
                    Body b = (Body)bodies.elementAt(i);
                    if (b.defaultSummary == null || b.getSummary() == null || b.defaultSummary.equals(b.getSummary())) continue;
                    b.defaultSummary = null;
                }
                for (int v = 0; v < bodies.size(); ++v) {
                    String s = MessageFormat.format(i18n.getString("lp.newValue"), new Integer(v));
                    for (int i = 0; i < bodies.size(); ++i) {
                        Body b = (Body)bodies.elementAt(i);
                        if (!s.equals(b.defaultSummary)) continue;
                        s = null;
                        break;
                    }
                    if (s == null) continue;
                    this.defaultSummary = s;
                    break;
                }
            }
            return this.defaultSummary;
        }

        public boolean isBodyFinishable() {
            return this.isInterviewFinishable();
        }
    }
}

