/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.dependent;

import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import org.jboss.cdi.tck.tests.context.dependent.Fox;
import org.jboss.cdi.tck.tests.context.dependent.HorseInStableEvent;

@Dependent
public class HorseStable {
    private static boolean dependentContextActive = false;
    private static Integer instanceThatObservedEventHashcode = null;
    private static Integer foxUsedForObservedEventHashcode = null;
    private static boolean destroyed = false;

    @Inject
    public HorseStable(BeanManager beanManager) {
        dependentContextActive = beanManager.getContext(Dependent.class).isActive();
    }

    public void horseEntered(@Observes HorseInStableEvent horseEvent, Fox fox) {
        instanceThatObservedEventHashcode = this.hashCode();
        foxUsedForObservedEventHashcode = fox.hashCode();
    }

    @PreDestroy
    public void destroy() {
        destroyed = true;
    }

    public static boolean isDependentContextActive() {
        return dependentContextActive;
    }

    public static void reset() {
        dependentContextActive = false;
        instanceThatObservedEventHashcode = null;
        foxUsedForObservedEventHashcode = null;
        destroyed = false;
    }

    public static Integer getInstanceThatObservedEventHashcode() {
        return instanceThatObservedEventHashcode;
    }

    public static Integer getFoxUsedForObservedEventHashcode() {
        return foxUsedForObservedEventHashcode;
    }

    public static boolean isDestroyed() {
        return destroyed;
    }
}

