/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.cdi.tck.api.Configuration;
import org.jboss.cdi.tck.impl.ConfigurationImpl;
import org.jboss.cdi.tck.spi.Beans;
import org.jboss.cdi.tck.spi.Contexts;
import org.jboss.cdi.tck.spi.EL;

public class PropertiesBasedConfigurationBuilder {
    public static final String RESOURCE_BUNDLE = "META-INF/cdi-tck.properties";
    private final Configuration configuration = new ConfigurationImpl();

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public PropertiesBasedConfigurationBuilder init(boolean deploymentPhase) {
        this.configuration.setCdiLiteMode(this.getBooleanValue("org.jboss.cdi.tck.cdiLiteMode", Boolean.FALSE, false));
        this.configuration.setBeans(this.getInstanceValue(Beans.PROPERTY_NAME, Beans.class, !deploymentPhase));
        this.configuration.setEl(this.getInstanceValue(EL.PROPERTY_NAME, EL.class, !deploymentPhase));
        this.configuration.setContexts(this.getInstanceValue(Contexts.PROPERTY_NAME, Contexts.class, !deploymentPhase));
        this.configuration.setLibraryDirectory(this.getStringValue("org.jboss.cdi.tck.libraryDirectory", null, deploymentPhase));
        if (!this.configuration.getCdiLiteMode().booleanValue()) {
            this.configuration.setTestDataSource(this.getStringValue("org.jboss.cdi.tck.testDataSource", null, deploymentPhase));
            this.configuration.setTestJmsConnectionFactory(this.getStringValue("org.jboss.cdi.tck.testJmsConnectionFactory", null, deploymentPhase));
            this.configuration.setTestJmsQueue(this.getStringValue("org.jboss.cdi.tck.testJmsQueue", null, deploymentPhase));
            this.configuration.setTestJmsTopic(this.getStringValue("org.jboss.cdi.tck.testJmsTopic", null, deploymentPhase));
        }
        this.configuration.setTestTimeoutFactor(this.getIntegerValue("org.jboss.cdi.tck.testTimeoutFactor", 100, false));
        return this;
    }

    public Set<String> getPropertyValues(String key) {
        HashSet<String> values = new HashSet<String>();
        this.addPropertiesFromSystem(key, values);
        this.addPropertiesFromResourceBundle(key, values);
        return values;
    }

    public String getStringValue(String propertyName, String defaultValue, boolean required) {
        String value = this.getValue(propertyName, required);
        return value != null ? value : defaultValue;
    }

    public long getLongValue(String propertyName, long defaultValue, boolean required) {
        try {
            String value = this.getValue(propertyName, required);
            return value != null ? Long.valueOf(value) : defaultValue;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid property value", e);
        }
    }

    public int getIntegerValue(String propertyName, int defaultValue, boolean required) {
        try {
            String value = this.getValue(propertyName, required);
            return value != null ? Integer.valueOf(value) : defaultValue;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid property value", e);
        }
    }

    public Boolean getBooleanValue(String propertyName, Boolean defaultValue, boolean required) {
        try {
            String value = this.getValue(propertyName, required);
            return value != null ? Boolean.valueOf(value) : defaultValue;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid property value", e);
        }
    }

    private void addPropertiesFromSystem(String key, Set<String> values) {
        this.addProperty(key, System.getProperty(key), values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPropertiesFromResourceBundle(String key, Set<String> values) {
        try {
            Enumeration<URL> e = this.getResources(RESOURCE_BUNDLE);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                Properties properties = new Properties();
                InputStream propertyStream = url.openStream();
                try {
                    properties.load(propertyStream);
                    this.addProperty(key, properties.getProperty(key), values);
                }
                finally {
                    if (propertyStream == null) continue;
                    propertyStream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addProperty(String key, String value, Set<String> values) {
        if (value != null) {
            values.add(value);
        }
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader().getResources(name);
        }
        return this.getClass().getClassLoader().getResources(name);
    }

    protected <T> T getInstanceValue(String propertyName, Class<T> expectedType, boolean required) {
        T instance = null;
        Class<T> clazz = this.getClassValue(propertyName, expectedType, required);
        if (clazz != null) {
            try {
                instance = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Error instantiating " + clazz + " specified by " + propertyName, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Error instantiating " + clazz + " specified by " + propertyName, e);
            }
        }
        return instance;
    }

    protected <T> Class<T> getClassValue(String propertyName, Class<T> expectedType, boolean required) {
        HashSet classes = new HashSet();
        for (String className : this.getPropertyValues(propertyName)) {
            ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (currentThreadClassLoader != null) {
                    classes.add(currentThreadClassLoader.loadClass(className));
                    continue;
                }
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException | LinkageError e) {
                throw new IllegalArgumentException("Implementation class with name " + className + " not found using classloader " + (currentThreadClassLoader != null ? currentThreadClassLoader : this.getClass().getClassLoader()), e);
            }
        }
        if (classes.size() == 0) {
            if (required) {
                throw new IllegalArgumentException("Cannot find any implementations of " + expectedType.getSimpleName() + ", check that " + propertyName + " is specified");
            }
            return null;
        }
        if (classes.size() > 1) {
            throw new IllegalArgumentException("More than one implementation of " + expectedType.getSimpleName() + " specified by " + propertyName + ", not sure which one to use!");
        }
        return (Class)classes.iterator().next();
    }

    private String getValue(String propertyName, boolean required) {
        Set<String> values = this.getPropertyValues(propertyName);
        if (values.size() == 0) {
            if (required) {
                throw new IllegalArgumentException("Cannot find required property " + propertyName + ", check that it is specified. See cdiLiteMode flag if testing CDI Lite.");
            }
            return null;
        }
        if (values.size() > 1) {
            throw new IllegalArgumentException("More than one value given for " + propertyName + ", not sure which one to use!");
        }
        return values.iterator().next();
    }
}

