/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.beanManager.unmanaged;

import jakarta.enterprise.inject.spi.Unmanaged;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.beanManager.unmanaged.Axe;
import org.jboss.cdi.tck.tests.extensions.beanManager.unmanaged.Builder;
import org.jboss.cdi.tck.tests.extensions.beanManager.unmanaged.Elephant;
import org.jboss.cdi.tck.tests.extensions.beanManager.unmanaged.Hammer;
import org.jboss.cdi.tck.tests.extensions.beanManager.unmanaged.Nail;
import org.jboss.cdi.tck.tests.extensions.beanManager.unmanaged.Proboscis;
import org.jboss.cdi.tck.tests.extensions.beanManager.unmanaged.ToolInterceptor;
import org.jboss.cdi.tck.tests.extensions.beanManager.unmanaged.Zoo;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class UnmanagedInstanceTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(UnmanagedInstanceTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_unmanaged_instance", id="a")})
    public void testObtainNonContextualInstanceUsingCurrentBeanManager() {
        Builder.reset();
        Nail.reset();
        Hammer.reset();
        Unmanaged unmanagedBuilder = new Unmanaged(this.getCurrentManager(), Builder.class);
        Unmanaged.UnmanagedInstance unmanagedBuilderInstance = unmanagedBuilder.newInstance();
        Builder builder = (Builder)unmanagedBuilderInstance.produce().inject().postConstruct().get();
        builder.build();
        Assert.assertTrue((boolean)Builder.postConstructCalled);
        Assert.assertTrue((boolean)Nail.postConstructCalled);
        Assert.assertTrue((boolean)Hammer.postConstructCalled);
        unmanagedBuilderInstance.preDestroy().dispose();
        Assert.assertTrue((boolean)Builder.preDestroyCalled);
        Assert.assertTrue((boolean)Nail.preDestroyCalled);
        Assert.assertFalse((boolean)Hammer.preDestroyCalled);
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="bm_obtain_unmanaged_instance", id="b")
    public void testObtainNonContextualInstance() {
        Zoo.reset();
        Proboscis.reset();
        Elephant.reset();
        Unmanaged unmanagedZoo = new Unmanaged(Zoo.class);
        Unmanaged.UnmanagedInstance unmanagedZooInstance = unmanagedZoo.newInstance();
        Zoo zoo = (Zoo)unmanagedZooInstance.produce().inject().postConstruct().get();
        zoo.build();
        Assert.assertTrue((boolean)Zoo.postConstructCalled);
        Assert.assertTrue((boolean)Proboscis.postConstructCalled);
        Assert.assertTrue((boolean)Elephant.postConstructCalled);
        unmanagedZooInstance.preDestroy().dispose();
        Assert.assertTrue((boolean)Zoo.preDestroyCalled);
        Assert.assertTrue((boolean)Proboscis.preDestroyCalled);
        Assert.assertFalse((boolean)Elephant.preDestroyCalled);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="biz_method_ee", id="ac")})
    public void testNonContextualInstanceIsIntercepted() {
        ToolInterceptor.intercepted = false;
        Unmanaged unmanagedAxe = new Unmanaged(this.getCurrentManager(), Axe.class);
        Unmanaged.UnmanagedInstance unmanagedAxeInstance = unmanagedAxe.newInstance();
        ((Axe)unmanagedAxeInstance.produce().inject().postConstruct().get()).cut();
        unmanagedAxeInstance.preDestroy().dispose();
        Assert.assertTrue((boolean)ToolInterceptor.intercepted);
    }
}

