/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat, Inc., and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.cdi.tck.tests.context.request.event.remote;

import javax.ejb.Stateless;
import javax.inject.Inject;

@Stateless
public class FooBean implements FooRemote {

    @Inject
    private RequestScopedObserver requestScopedObserver;

    @Inject
    private ApplicationScopedObserver applicationScopedObserver;

    /**
     * Verifies that the request context is active during remote method invocation and that @Initialized(RequestScoped.class)
     * was fired when this context was initialized. Also resets {@link ApplicationScopedObserver} which detects @Destroyed
     * events.
     */
    public boolean first() {
        applicationScopedObserver.reset();
        return requestScopedObserver.isInitializedObserved();
    }

    /**
     * Verifies that the request context is active during remote method invocation and that @Initialized(RequestScoped.class)
     * was fired when this context was initialized. Furthermore, this method verifies that the @Destroyed event observer that
     * was reset in the {@link #first()} invocation received @Destroyed event in the meantime (this event was fired once the
     * request context of the {@link #first()} invocation was destroyed).
     */
    public boolean second() {
        return requestScopedObserver.isInitializedObserved() && applicationScopedObserver.isDestroyedCalled();
    }
}
