/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.TypeLiteral;
import org.jboss.cdi.tck.util.SimpleLogger;

public final class BeanLookupUtils {
    private static final SimpleLogger logger = new SimpleLogger(BeanLookupUtils.class);

    private BeanLookupUtils() {
    }

    public static <T> T getContextualReference(BeanManager beanManager, Class<T> beanType, Annotation ... qualifiers) {
        Set<Bean<?>> beans = BeanLookupUtils.getBeans(beanManager, beanType, qualifiers);
        return BeanLookupUtils.getContextualReference(beanManager, beanType, beans);
    }

    public static <T> T getContextualReference(BeanManager beanManager, TypeLiteral<T> beanTypeLiteral, Annotation ... qualifiers) {
        Type beanType = beanTypeLiteral.getType();
        Set<Bean<?>> beans = BeanLookupUtils.getBeans(beanManager, beanType, qualifiers);
        return BeanLookupUtils.getContextualReference(beanManager, beanType, beans);
    }

    public static <T> T getContextualReference(BeanManager beanManager, String name, Class<T> beanType) {
        Set beans = beanManager.getBeans(name);
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        return BeanLookupUtils.getContextualReference(beanManager, beanType, beans);
    }

    private static Set<Bean<?>> getBeans(BeanManager beanManager, Type beanType, Annotation ... qualifiers) {
        Set beans = beanManager.getBeans(beanType, qualifiers);
        if (beans == null || beans.isEmpty()) {
            throw new UnsatisfiedResolutionException(String.format("No bean matches required type %s and required qualifiers %s", beanType, Arrays.toString(qualifiers)));
        }
        return beans;
    }

    private static <T> T getContextualReference(BeanManager beanManager, Type beanType, Set<Bean<?>> beans) {
        Bean bean = beanManager.resolve(beans);
        if (bean.getScope().equals(Dependent.class)) {
            logger.log("Dependent contextual instance cannot be properly destroyed!", new Object[0]);
        }
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        return (T)beanManager.getReference(bean, beanType, creationalContext);
    }
}

