/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.cdi;

import jakarta.batch.api.Batchlet;
import jakarta.batch.operations.JobOperator;
import jakarta.batch.runtime.context.JobContext;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;

@Dependent
@Named(value="CDIJobOperatorInjectedBatchlet")
public class JobOperatorInjectedBatchlet
implements Batchlet {
    @Inject
    JobContext jobCtx;
    @Inject
    JobOperator jobOperator;

    private void error(String errorMsg) throws Exception {
        this.jobCtx.setExitStatus("FAIL: " + errorMsg);
        throw new Exception(errorMsg);
    }

    public String process() throws Exception {
        long jobExecId = this.jobCtx.getExecutionId();
        String jobName = this.jobCtx.getJobName();
        List runningExecs = this.jobOperator.getRunningExecutions(jobName);
        if (!runningExecs.contains(jobExecId)) {
            this.error("JobOperator doesn't show: " + jobExecId + " in running executions list, shows: " + String.valueOf(runningExecs));
        }
        this.jobCtx.setExitStatus(Long.toString(jobExecId));
        return this.jobOperator.getClass().getCanonicalName();
    }

    public void stop() throws Exception {
    }
}

