/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.cdi;

import com.ibm.jbatch.tck.cdi.AppScopedTestBean;
import com.ibm.jbatch.tck.cdi.DependentScopedTestBean;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.Batchlet;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.StringWriter;
import java.util.Properties;

@Dependent
@Named(value="CDIDependentScopedBatchlet")
public class DependentScopedBatchlet
implements Batchlet {
    @Inject
    @BatchProperty(name="prop1")
    String prop1;
    @Inject
    AppScopedTestBean appScoped;
    @Inject
    DependentScopedTestBean dependentScoped;
    @Inject
    JobContext jobCtx;
    @Inject
    StepContext stepCtx;

    private void error(String errorMsg) throws Exception {
        this.jobCtx.setExitStatus("FAIL: " + errorMsg);
        throw new Exception(errorMsg);
    }

    public String process() throws Exception {
        if (this.dependentScoped != null && this.appScoped != null) {
            if (this.jobCtx.getExecutionId() != this.dependentScoped.getJobContextExecId()) {
                this.error("jobCtx execution ids don't match, found: " + this.dependentScoped.getJobContextExecId());
            } else if (this.stepCtx.getStepExecutionId() != this.dependentScoped.getStepContextExecId()) {
                this.error("step execution ids don't match, found: " + this.dependentScoped.getStepContextExecId());
            } else if (this.prop1 != this.dependentScoped.getProp1Val()) {
                this.error("prop1 property values don't match, found: " + this.dependentScoped.getProp1Val());
            }
            this.jobCtx.setExitStatus(this.jobCtx.getExecutionId() + ":" + this.stepCtx.getStepExecutionId() + ":" + this.prop1);
        } else {
            this.error("Null among dependentScoped = " + String.valueOf(this.dependentScoped) + ", appScoped = " + String.valueOf(this.appScoped));
        }
        return "OK";
    }

    public void stop() throws Exception {
    }

    public static String getPropertyAsString(Properties prop) throws Exception {
        StringWriter writer = new StringWriter();
        prop.store(writer, "");
        return writer.getBuffer().toString();
    }
}

