/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.listener.JobListener;
import jakarta.batch.api.listener.StepListener;
import jakarta.batch.runtime.context.JobContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.logging.Logger;

@Named(value="myUniversalListener")
public class MyUniversalListener
implements JobListener,
StepListener {
    private static final Logger logger = Logger.getLogger(MyUniversalListener.class.getName());
    @Inject
    private JobContext jobCtx = null;
    @Inject
    @BatchProperty(name="app.timeinterval")
    String timeintervalString;
    int timeinterval = 0;

    public void beforeJob() {
        String cur = this.jobCtx.getExitStatus();
        Object status = cur == null ? "BeforeJob" : cur + "BeforeJob";
        this.jobCtx.setExitStatus((String)status);
    }

    public void afterJob() {
        String cur = this.jobCtx.getExitStatus();
        this.jobCtx.setExitStatus(cur + "AfterJob");
    }

    public void beforeStep() {
        this.timeinterval = Integer.parseInt(this.timeintervalString);
        String cur = this.jobCtx.getExitStatus();
        this.jobCtx.setExitStatus(cur + "BeforeStep");
    }

    public void afterStep() {
        logger.fine("AJM: gonna sleep for " + this.timeinterval);
        try {
            Thread.sleep(this.timeinterval);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String cur = this.jobCtx.getExitStatus();
        this.jobCtx.setExitStatus(cur + "AfterStep");
    }
}

