/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.Decider;
import jakarta.batch.runtime.StepExecution;
import jakarta.batch.runtime.context.JobContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.Comparator;

@Named(value="deciderReceivesCorrectStepExecutionsDecider")
public class DeciderReceivesCorrectStepExecutionsDecider
implements Decider {
    @Inject
    JobContext jobCtx;
    @Inject
    @BatchProperty(name="expected.number.of.step.executions")
    String numOfStepExecs;

    public String decide(StepExecution[] stepExecutions) throws Exception {
        if (stepExecutions.length != Integer.parseInt(this.numOfStepExecs)) {
            throw new Exception("Expecting stepExecutions array of size " + this.numOfStepExecs + ", found one of size = " + stepExecutions.length);
        }
        this.sortStepExecutionsByStepName(stepExecutions);
        Object exitStatus = "";
        for (StepExecution stepExecution : stepExecutions) {
            exitStatus = (String)exitStatus + stepExecution.getStepName() + ":" + stepExecution.getStepExecutionId() + ";";
        }
        return exitStatus;
    }

    private void sortStepExecutionsByStepName(StepExecution[] stepExecutions) {
        Arrays.sort(stepExecutions, new Comparator<StepExecution>(){

            @Override
            public int compare(StepExecution se1, StepExecution se2) {
                return se1.getStepName().compareTo(se2.getStepName());
            }
        });
    }
}

