/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.reusable.MyPersistentUserData;
import jakarta.batch.api.AbstractBatchlet;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.logging.Logger;

@Named(value="batchletUsingStepContextImpl")
public class BatchletUsingStepContextImpl
extends AbstractBatchlet {
    private static final Logger logger = Logger.getLogger(BatchletUsingStepContextImpl.class.getName());
    @Inject
    private StepContext stepCtx = null;
    @Inject
    private JobContext jobCtx = null;
    private String BEGAN = "MadeItToBegin";
    private String CANCEL = "Cancelled";
    private String PROCESSED = "Processed";
    @Inject
    @BatchProperty(name="force.failure")
    String forceFailureProp;
    private boolean forceFailure = false;
    public static String GOOD_STEP_EXIT_STATUS = "VERY GOOD INVOCATION";
    public static String GOOD_JOB_EXIT_STATUS = "JOB: " + GOOD_STEP_EXIT_STATUS;

    private void begin() throws Exception {
        logger.fine("BatchletUsingStepContextImpl - @BeginStep");
        assert (this.stepCtx.getExitStatus() == null);
        this.stepCtx.setExitStatus(this.BEGAN);
        if ("true".equalsIgnoreCase(this.forceFailureProp)) {
            this.forceFailure = true;
        }
    }

    public String process() throws Exception {
        this.begin();
        logger.fine("BatchletUsingStepContextImpl - @Process");
        assert (this.stepCtx.getExitStatus().equals(this.BEGAN));
        MyPersistentUserData myData = null;
        myData = (MyPersistentUserData)this.stepCtx.getPersistentUserData();
        if (myData != null) {
            if (this.forceFailure) {
                this.forceFailure = false;
                this.stepCtx.setPersistentUserData((Serializable)new MyPersistentUserData(myData.getData() + 1, this.forceFailure));
            }
        } else if (this.forceFailure) {
            this.stepCtx.setPersistentUserData((Serializable)new MyPersistentUserData(4, this.forceFailure));
        }
        this.stepCtx.setTransientUserData((Object)new MyTransient(3));
        this.stepCtx.setExitStatus(this.PROCESSED);
        this.end();
        if (this.forceFailure) {
            throw new Exception("Fail on purpose in BatchletUsingStepContextImpl.process()");
        }
        return BatchStatus.COMPLETED.name();
    }

    public void stop() throws Exception {
        logger.fine("BatchletUsingStepContextImpl - @Cancel");
        this.stepCtx.setExitStatus(this.CANCEL);
    }

    private void end() throws Exception {
        logger.fine("BatchletUsingStepContextImpl - formerly @EndStep");
        MyPersistentUserData p = (MyPersistentUserData)this.stepCtx.getPersistentUserData();
        MyTransient t = (MyTransient)this.stepCtx.getTransientUserData();
        assert (this.stepCtx.getExitStatus().equals(this.PROCESSED));
        this.stepCtx.setExitStatus(GOOD_STEP_EXIT_STATUS);
        this.jobCtx.setExitStatus(GOOD_JOB_EXIT_STATUS);
    }

    private class MyTransient {
        int data = 0;

        MyTransient(int x) {
            this.data = x;
        }
    }
}

