/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.interview.wizard.ActionDocListener;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.TypeInPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class StringQuestionRenderer
implements QuestionRenderer {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    @Override
    public JComponent getQuestionRendererComponent(Question q, ActionListener listener) {
        StringQuestion sq = (StringQuestion)q;
        int nomMaxLen = sq.getNominalMaxLength();
        if (nomMaxLen > 80) {
            return this.createTextArea(sq, listener);
        }
        return this.createTypeInPanel(sq, listener);
    }

    @Override
    public String getInvalidValueMessage(Question q) {
        return null;
    }

    protected JPanel createTextArea(StringQuestion q, ActionListener listener) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setName("str");
        panel.setFocusable(false);
        JLabel label = new JLabel(i18n.getString("str.area.lbl"));
        label.setName("str.area.lbl");
        label.setDisplayedMnemonic(i18n.getString("str.area.mne").charAt(0));
        label.setToolTipText(i18n.getString("str.area.tip"));
        panel.add((Component)label, "North");
        JTextArea textArea = new JTextArea(q.getValue());
        textArea.setName("str");
        textArea.setLineWrap(true);
        textArea.getDocument().addDocumentListener(new ActionDocListener(textArea, listener, "edited"));
        textArea.setToolTipText(label.getToolTipText());
        label.setLabelFor(textArea);
        JScrollPane sp = new JScrollPane(textArea);
        sp.setName("str.sp");
        sp.setFocusable(false);
        panel.add((Component)sp, "Center");
        panel.putClientProperty("valueSaver", this.createValueSaver(q, textArea));
        return panel;
    }

    protected JPanel createTypeInPanel(StringQuestion q, ActionListener listener) {
        return new TypeInPanel("str", q, q.getNominalMaxLength(), q.getSuggestions(), null, listener);
    }

    protected Runnable createValueSaver(StringQuestion q, JTextArea textArea) {
        return () -> q.setValue(textArea.getText());
    }
}

