/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.toyxml;

import com.sun.tdk.signaturetest.toyxml.Elem;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ToyParser {
    private static final Pattern elm = Pattern.compile("<.+?>");
    private static final Pattern single = Pattern.compile("<(.+)/>");
    private static final Pattern close = Pattern.compile("</(.+)>");
    private static final Pattern open = Pattern.compile("<(.+)>");
    private static final Pattern name = Pattern.compile("\\w+\\s");
    private static final Pattern attrs = Pattern.compile("(\\w+=\"[^\"]+?\")+");
    private static final Pattern attrMask = Pattern.compile("(\\w+)=\"(.+)\"");
    private Elem root = null;

    public Elem parse(String in) {
        assert (in != null && !in.isEmpty());
        Matcher matcher = elm.matcher(in);
        Stack<Elem> stack = new Stack<Elem>();
        while (matcher.find()) {
            String el = matcher.group();
            Kind k = this.getLexKind(el);
            if (k == Kind.OPEN) {
                this.openElement(el, stack);
                continue;
            }
            if (k == Kind.SINGLE) {
                this.singleElement(el, stack);
                continue;
            }
            if (k != Kind.CLOSE) continue;
            this.closeElement(el, stack);
        }
        return this.root;
    }

    private void closeElement(String def, Stack<Elem> stack) {
        Elem e = stack.peek();
        Matcher m = close.matcher(def);
        if (m.find() && m.group(1).equals(e.getNodeName())) {
            stack.pop();
            return;
        }
    }

    private void singleElement(String def, Stack<Elem> stack) {
        this.addElement(def, stack, single, false);
    }

    private void openElement(String def, Stack<Elem> stack) {
        this.addElement(def, stack, open, true);
    }

    private void addElement(String def, Stack<Elem> stack, Pattern pat, boolean add) {
        Elem parent;
        Matcher m;
        Elem el = new Elem();
        if (this.root == null) {
            this.root = el;
        }
        if ((m = pat.matcher(def)).find()) {
            this.makeElem(el, m.group(1));
        }
        Elem elem = parent = stack.isEmpty() ? null : stack.peek();
        if (parent != null) {
            parent.addChild(el);
        }
        if (add) {
            stack.push(el);
        }
    }

    private void makeElem(Elem el, String txt) {
        Matcher mn = name.matcher(txt);
        if (!mn.find()) {
            throw new IllegalStateException(txt);
        }
        el.setNodeName(mn.group().trim());
        Matcher ma = attrs.matcher(txt);
        while (ma.find()) {
            String attrSt = ma.group();
            Matcher m = attrMask.matcher(attrSt);
            if (!m.find()) continue;
            el.addAttribute(m.group(1), m.group(2));
        }
    }

    private Kind getLexKind(String el) {
        if (close.matcher(el).find()) {
            return Kind.CLOSE;
        }
        if (single.matcher(el).find()) {
            return Kind.SINGLE;
        }
        if (open.matcher(el).find()) {
            return Kind.OPEN;
        }
        throw new IllegalArgumentException(el);
    }

    static enum Kind {
        SINGLE,
        OPEN,
        CLOSE;

    }
}

