/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.chunktypes.ReadRecord;
import com.ibm.jbatch.tck.artifacts.reusable.MyParentException;
import java.util.List;
import java.util.logging.Logger;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.listener.SkipWriteListener;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.testng.Reporter;

@Named(value="verifySkipWriteListener")
public class VerifySkipWriteListener
implements SkipWriteListener {
    @Inject
    JobContext jobCtx;
    @Inject
    StepContext stepCtx;
    @Inject
    @BatchProperty(name="test.itemcount")
    String numberOfExpectedItems;
    private static final String sourceClass = VerifySkipWriteListener.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    public static final String GOOD_EXIT_STATUS = "VerifySkipWriteListener: GOOD STATUS, GOOD OBJS PASSED IN";
    public static final String BAD_EXIT_STATUS = "VerifySkipWriteListener: BAD STATUS";
    private static int[] expectedValues = new int[]{16, 17, 18, 25, 26, 27, 34, 35, 36};
    private static int indexOfExpectedValue = 0;

    public void onSkipWriteItem(List items, Exception e) throws Exception {
        Reporter.log((String)("In onSkipWriteItem()" + e + "<p>"));
        ReadRecord input = null;
        boolean inputOK = true;
        int numberOfNonNullItemsFound = 0;
        for (Object obj : items) {
            input = (ReadRecord)obj;
            if (obj == null) {
                logger.finer("In onSkipProcessItem(), NULL object in items list<p>");
                inputOK = false;
            } else {
                logger.finer("In onSkipProcessItem(), item count = " + input.getCount());
                ++numberOfNonNullItemsFound;
                if (input.getCount() != expectedValues[indexOfExpectedValue]) {
                    inputOK = false;
                    logger.finer("In onSkipProcessItem(), wrong item value. Expected " + expectedValues[indexOfExpectedValue] + ", found " + input.getCount() + "<p>");
                }
            }
            ++indexOfExpectedValue;
        }
        if (this.numberOfExpectedItems != null && Integer.parseInt(this.numberOfExpectedItems) != numberOfNonNullItemsFound) {
            inputOK = false;
            logger.finer("Wrong number of items. Expected " + this.numberOfExpectedItems + ", found " + numberOfNonNullItemsFound + "<p>");
        }
        if (!(e instanceof MyParentException) || !inputOK) {
            Reporter.log((String)"VERIFYSKIPLISTENER: onSkipWriteItem, exception is NOT an instance of: MyParentException<p>");
            this.jobCtx.setExitStatus(BAD_EXIT_STATUS);
            throw new Exception();
        }
        Reporter.log((String)"VERIFYSKIPLISTENER: onSkipWriteItem, exception is an instance of: MyParentException<p>");
        this.jobCtx.setExitStatus(GOOD_EXIT_STATUS);
    }
}

