/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.specialized.MyCustomCheckpointListener;
import java.util.Date;
import java.util.logging.Logger;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.listener.AbstractChunkListener;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="myTimeCheckpointListener")
public class MyTimeCheckpointListener
extends AbstractChunkListener {
    private static final String sourceClass = MyCustomCheckpointListener.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    Date date;
    long ts;
    int timeinterval;
    boolean init = true;
    long startTime = 0L;
    long endTime = 0L;
    @Inject
    @BatchProperty(name="timeinterval")
    String timeintervalString;
    @Inject
    JobContext jobCtx;
    @Inject
    StepContext stepCtx;

    public void beforeChunk() {
        logger.fine("CHUNKLISTENER: beforeChunk");
        this.timeinterval = Integer.parseInt(this.timeintervalString);
        logger.fine("CHUNKLISTENER: got the timeinterval: " + this.timeinterval);
        logger.fine("CHUNKLISTENER: startTime: " + this.startTime);
        logger.fine("CHUNKLISTENER: endTime: " + this.endTime);
        long curdiff = this.endTime - this.startTime;
        logger.fine("CHUNKLISTENER: curdiff: " + curdiff);
        int diff = 0;
        diff = curdiff == 0L ? 0 : (int)((long)((int)this.endTime) - this.startTime) / 1000;
        logger.fine("AJM: time diff =" + diff);
        if (diff >= this.timeinterval - 1 && diff <= this.timeinterval + 1) {
            logger.fine("CHUNKLISTENER: the checkpoint is occuring at the correct time -> " + diff + " which is: " + this.timeinterval + " +/- 1 second");
            this.jobCtx.setExitStatus("TRUE: " + diff);
        } else {
            logger.fine("CHUNKLISTENER: checkpoint outside the window surrounding the time interval of " + this.timeinterval);
            this.jobCtx.setExitStatus("FALSE: " + diff);
        }
        this.startTime = System.currentTimeMillis();
    }

    public void afterChunk() {
        logger.fine("CHUNKLISTENER: afterChunk");
        this.date = new Date();
        this.ts = this.date.getTime();
        this.endTime = System.currentTimeMillis();
    }

    public void onError(Exception e) {
        logger.fine("CHUNKLISTENER: onError");
    }
}

