/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.cdo.repository;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.docs.intent.collab.cdo.repository.CDOConfig;
import org.eclipse.mylyn.docs.intent.collab.common.repository.contribution.IntentRepositoryManagerContribution;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryStructurer;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryCreator;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryRegistry;

public class IntentCDOBasedRepositoryManagerContribution
implements IntentRepositoryManagerContribution {
    public boolean canCreateRepository(String identifier) {
        return identifier.contains("cdo:/");
    }

    public Repository createRepository(String identifier) throws RepositoryConnectionException {
        String repositoryType = "org.eclipse.mylyn.docs.intent.collab.cdo.repository";
        try {
            RepositoryCreator repositoryCreator = RepositoryRegistry.INSTANCE.getRepositoryCreator(repositoryType);
            RepositoryStructurer repositoryStructurer = RepositoryRegistry.INSTANCE.getRepositoryStructurer(repositoryType);
            if (repositoryCreator == null) {
                throw new RepositoryConnectionException("Cannot instantiate a repository of type:" + repositoryType);
            }
            CDOConfig config = new CDOConfig("localhost:2036", this.getRepositoryName(identifier));
            return repositoryCreator.createRepository((Object)config, repositoryStructurer);
        }
        catch (CoreException e) {
            throw new RepositoryConnectionException(e.getMessage());
        }
    }

    private String getRepositoryName(String identifier) {
        String repositoryName = identifier.replaceFirst("cdo:/", "");
        repositoryName = repositoryName.split("/")[0];
        return repositoryName;
    }
}

