/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.synchronizer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.docs.intent.client.synchronizer.SynchronizeRepositoryJob;
import org.eclipse.mylyn.docs.intent.client.synchronizer.listeners.GeneratedElementListener;
import org.eclipse.mylyn.docs.intent.client.synchronizer.synchronizer.IntentSynchronizer;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.AbstractRepositoryClient;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotification;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusManager;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizerRepositoryClient
extends AbstractRepositoryClient {
    private IntentSynchronizer synchronizer;
    private TraceabilityIndex traceabilityIndex;
    private CompilationStatusManager statusManager;

    public SynchronizerRepositoryClient(TraceabilityIndex traceabilityIndex, CompilationStatusManager statusManager, Repository repository) {
        super(repository);
        IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[Synchronizer] Ready");
        this.synchronizer = new IntentSynchronizer(this);
        this.traceabilityIndex = traceabilityIndex;
        this.statusManager = statusManager;
    }

    public void addAllStatusToTargetElement(Collection<? extends CompilationStatus> statusList) {
        Iterator allPreviousStatus = Iterables.filter((Iterable)this.statusManager.getCompilationStatusList(), SynchronizerCompilationStatus.class).iterator();
        LinkedHashSet toAdd = Sets.newLinkedHashSet();
        toAdd.addAll(statusList);
        LinkedHashSet toRemove = Sets.newLinkedHashSet();
        while (allPreviousStatus.hasNext()) {
            SynchronizerCompilationStatus oldStatus = (SynchronizerCompilationStatus)allPreviousStatus.next();
            if (oldStatus.getTarget() != null) continue;
            toRemove.add(oldStatus);
        }
        Iterator toAddIterator = toAdd.iterator();
        while (toAddIterator.hasNext()) {
            boolean addCandidateIsActuallyNewStatus;
            CompilationStatus toAddCandidate = (CompilationStatus)toAddIterator.next();
            boolean bl = addCandidateIsActuallyNewStatus = toAddCandidate.getTarget() != null;
            if (addCandidateIsActuallyNewStatus) {
                Iterator toAddCandidateTargetStatusesIterator = toAddCandidate.getTarget().getCompilationStatus().iterator();
                while (addCandidateIsActuallyNewStatus && toAddCandidateTargetStatusesIterator.hasNext()) {
                    boolean bl2 = addCandidateIsActuallyNewStatus = !toAddCandidate.getMessage().equals(((CompilationStatus)toAddCandidateTargetStatusesIterator.next()).getMessage());
                }
            }
            if (addCandidateIsActuallyNewStatus) continue;
            this.statusManager.getCompilationStatusList().add((Object)toAddCandidate);
            toAddIterator.remove();
        }
        for (CompilationStatus oldSyncStatus : toRemove) {
            if (oldSyncStatus.getTarget() == null) continue;
            oldSyncStatus.getTarget().getCompilationStatus().remove((Object)oldSyncStatus);
        }
        this.statusManager.getCompilationStatusList().removeAll((Collection)toRemove);
        for (CompilationStatus status : toAdd) {
            if (status.getTarget() == null) continue;
            status.getTarget().getCompilationStatus().add((Object)status);
            this.statusManager.getCompilationStatusList().add((Object)status);
        }
        this.statusManager.setSynchronizationTime(BigInteger.valueOf(System.currentTimeMillis()));
    }

    public void setGeneratedElementListener(GeneratedElementListener generatedElementListener) {
        this.synchronizer.setGeneratedElementListener(generatedElementListener);
        generatedElementListener.setSynchronizer(this);
    }

    public TraceabilityIndex getTraceabilityIndex() {
        return this.traceabilityIndex;
    }

    public void setTraceabilityIndex(TraceabilityIndex traceabilityIndex) {
        this.traceabilityIndex = traceabilityIndex;
    }

    IntentSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    protected Job createNotificationJob(RepositoryChangeNotification notification) {
        return new SynchronizeRepositoryJob(this);
    }

    public void dispose() {
        this.synchronizer.dispose();
        super.dispose();
    }
}

