/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.docs.intent.client.ui.ide.builder.ToggleNatureAction;
import org.eclipse.mylyn.docs.intent.client.ui.ide.wizards.IntentTemplateWizardPage;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.client.ui.preferences.IntentPreferenceService;
import org.eclipse.mylyn.docs.intent.client.ui.utils.IntentEditorOpener;
import org.eclipse.mylyn.docs.intent.collab.common.repository.IntentRepositoryInitializer;
import org.eclipse.mylyn.docs.intent.collab.common.repository.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetView;

public class NewIntentProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private static final String NEW_INTENT_PROJECT_TITLE = "New Intent project";
    private static final String DEFAULT_INTENT_DOCUMENT = "Document {\n}";
    protected WizardNewProjectCreationPage page;
    protected IntentTemplateWizardPage templatePage;
    protected IConfigurationElement configElement;

    public NewIntentProjectWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New Intent Project");
    }

    public void addPages() {
        this.page = new WizardNewProjectCreationPage(NEW_INTENT_PROJECT_TITLE){

            public void createControl(Composite parent) {
                super.createControl(parent);
                this.createWorkingSetGroup((Composite)this.getControl(), (IStructuredSelection)new StructuredSelection(), new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage"});
            }
        };
        this.page.setTitle(NEW_INTENT_PROJECT_TITLE);
        this.page.setDescription("Select project name");
        this.addPage((IWizardPage)this.page);
        this.templatePage = new IntentTemplateWizardPage();
        this.templatePage.setTitle("Template Selection");
        this.addPage((IWizardPage)this.templatePage);
    }

    public boolean performFinish() {
        String defaultContent = this.getDefaultContent();
        NewIntentProjectWizardRunnable workspaceOperation = new NewIntentProjectWizardRunnable(this.page, defaultContent);
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)workspaceOperation);
            try {
                final Repository repository = IntentRepositoryManager.INSTANCE.getRepository(this.page.getProjectName());
                if (repository != null) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            NewIntentProjectWizard.this.uiFinishOperations(repository);
                        }
                    };
                    Display.getDefault().asyncExec(runnable);
                }
            }
            catch (RepositoryConnectionException e) {
                IntentUiLogger.logError((Throwable)e);
            }
            return true;
        }
        catch (CoreException e) {
            IntentUiLogger.logError((Throwable)e);
        }
        catch (InterruptedException e) {
            IntentUiLogger.logError((Throwable)e);
        }
        catch (InvocationTargetException e) {
            IntentUiLogger.logError((Throwable)e);
        }
        return false;
    }

    private void uiFinishOperations(Repository repository) {
        try {
            IViewPart cheatSheetView;
            IntentEditorOpener.openIntentEditor((Repository)repository, (boolean)false);
            if (IntentPreferenceService.getBoolean((String)"org.eclipse.mylyn.docs.intent.client.ui.preferences.show_cheat_sheet").booleanValue() && (cheatSheetView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.cheatsheets.views.CheatSheetView")) instanceof CheatSheetView) {
                ((CheatSheetView)cheatSheetView).setInput("org.eclipse.mylyn.docs.intent.idoc.cheatsheet.getstarted");
            }
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.navigator.ProjectExplorer");
        }
        catch (PartInitException e) {
            IntentUiLogger.logError((Throwable)e);
        }
    }

    private String getDefaultContent() {
        String templateContent;
        if (this.getContainer().getCurrentPage().equals((Object)this.templatePage) && (templateContent = this.templatePage.getContent()) != null) {
            return templateContent;
        }
        return DEFAULT_INTENT_DOCUMENT;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.configElement = config;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage().equals(this.page) && this.page.isPageComplete() || this.getContainer().getCurrentPage().equals((Object)this.templatePage) && this.templatePage.isPageComplete();
    }

    static class NewIntentProjectWizardRunnable
    extends WorkspaceModifyOperation {
        protected WizardNewProjectCreationPage page;
        private String defaultContent;

        public NewIntentProjectWizardRunnable(WizardNewProjectCreationPage page, String defaultContent) {
            this.page = page;
            this.defaultContent = defaultContent;
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.page.getProjectName());
            IPath location = this.page.getLocationPath();
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(this.page.getProjectName());
                if (location != null && ResourcesPlugin.getWorkspace().getRoot().getLocation().equals((Object)location)) {
                    location = null;
                }
                desc.setLocation(location);
                project.create(desc, monitor);
                project.open(monitor);
            }
            if (!project.isOpen()) {
                project.open(monitor);
            }
            IWorkingSet[] workingSets = this.page.getSelectedWorkingSets();
            if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getWorkingSetManager() != null) {
                PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)project, workingSets);
            }
            ToggleNatureAction.toggleNature(project);
            IntentRepositoryInitializer.initializeContent((String)project.getName(), (String)this.defaultContent);
        }
    }
}

