/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.editor.ComparisonScopeEditorInput;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorDocument;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.AbstractIntentFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.IntentCompareConfiguration;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.compare.scope.IntentComparisonScope;
import org.eclipse.mylyn.docs.intent.compare.utils.EMFCompareUtils;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;
import org.eclipse.swt.graphics.Image;

public class EMFCompareFix
extends AbstractIntentFix {
    private static final String COMPARE_EDITOR_TITLE = "Comparing Intent Document and Working Copy";

    public EMFCompareFix(IntentAnnotation annotation) {
        super(annotation);
    }

    protected void applyFix(RepositoryAdapter repositoryAdapter, IntentEditorDocument document) {
        URI workingCopyElementURI = URI.createURI((String)((SynchronizerCompilationStatus)this.syncAnnotation.getCompilationStatus()).getWorkingCopyResourceURI().replace("\"", ""));
        String generatedResourcePath = ((SynchronizerCompilationStatus)this.syncAnnotation.getCompilationStatus()).getCompiledResourceURI().replace("\"", "");
        EObject docElement = EcoreUtil.copy((EObject)((EObject)repositoryAdapter.getResource(generatedResourcePath).getContents().iterator().next()));
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource workingCopyResource = rs.getResource(workingCopyElementURI.trimFragment(), true);
        EObject workingCopyElement = null;
        workingCopyElement = workingCopyElementURI.hasFragment() ? workingCopyResource.getEObject(workingCopyElementURI.fragment()) : (EObject)workingCopyResource.getContents().iterator().next();
        IntentCompareConfiguration compareConfig = new IntentCompareConfiguration(workingCopyElement, docElement);
        ICompareEditingDomain domain = EMFCompareEditingDomain.create((Notifier)workingCopyElement, (Notifier)docElement, null);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        IntentComparisonScope scope = new IntentComparisonScope((Notifier)workingCopyElement, (Notifier)docElement);
        EMFCompare.Builder builder = EMFCompare.builder();
        builder.setMatchEngineFactoryRegistry(EMFCompareUtils.getMatchEngineNeverUsingIdentifiers());
        EMFCompare comparator = builder.build();
        ComparisonScopeEditorInput input = new ComparisonScopeEditorInput(new EMFCompareConfiguration((CompareConfiguration)compareConfig), domain, (AdapterFactory)adapterFactory, comparator, (IComparisonScope)scope);
        input.setTitle("Comparing Intent Document and Working Copy (" + workingCopyElementURI + ")");
        CompareUI.openCompareDialog((CompareEditorInput)input);
    }

    public String getDisplayString() {
        return "See all differences in Compare Editor";
    }

    public Image getImage() {
        return IntentEditorActivator.getDefault().getImage("icon/annotation/compare_dialog.gif");
    }
}

