/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.compare.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.DiffBuilder;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.DefaultEqualityHelperFactory;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IEqualityHelperFactory;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryImpl;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryRegistryImpl;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.UseIdentifiers;
import org.eclipse.mylyn.docs.intent.compare.match.EditionDistance;
import org.eclipse.mylyn.docs.intent.compare.scope.IntentComparisonScope;
import org.eclipse.mylyn.docs.intent.compare.utils.IntentFeatureFilter;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;

public final class EMFCompareUtils {
    private static IMatchEngine.Factory.Registry neverUsingIdentifiersMatchEngine;

    private EMFCompareUtils() {
    }

    public static Comparison compare(Notifier left, Notifier right) {
        IntentComparisonScope scope = new IntentComparisonScope(left, right);
        EMFCompare.Builder builder = EMFCompare.builder();
        builder.setMatchEngineFactoryRegistry(EMFCompareUtils.getMatchEngineNeverUsingIdentifiers());
        return builder.build().compare((IComparisonScope)scope);
    }

    public static Comparison compareDocuments(Notifier left, Notifier right) {
        IntentComparisonScope scope = new IntentComparisonScope(left, right);
        scope.setEObjectContentFilter(Predicates.not((Predicate)Predicates.or((Predicate)Predicates.instanceOf(CompilationStatus.class), (Predicate)Predicates.instanceOf(SynchronizerCompilationStatus.class))));
        IMatchEngine.Factory.Registry matchEngine = EMFCompareUtils.getIntentDocumentMatchEngine(left, right);
        DefaultDiffEngine diffEngine = new DefaultDiffEngine((IDiffProcessor)new DiffBuilder()){

            protected FeatureFilter createFeatureFilter() {
                return new IntentFeatureFilter();
            }
        };
        EMFCompare.Builder builder = EMFCompare.builder();
        builder.setDiffEngine((IDiffEngine)diffEngine);
        builder.setMatchEngineFactoryRegistry(matchEngine);
        return builder.build().compare((IComparisonScope)scope);
    }

    public static IMatchEngine.Factory.Registry getMatchEngineNeverUsingIdentifiers() {
        if (neverUsingIdentifiersMatchEngine == null) {
            IMatchEngine matchEngine = DefaultMatchEngine.create((UseIdentifiers)UseIdentifiers.NEVER);
            neverUsingIdentifiersMatchEngine = EMFCompareUtils.createMatchEngineRegistryFromMatchEngine(matchEngine);
        }
        return neverUsingIdentifiersMatchEngine;
    }

    private static IMatchEngine.Factory.Registry getIntentDocumentMatchEngine(Notifier left, Notifier right) {
        ProximityEObjectMatcher matcher = new ProximityEObjectMatcher((ProximityEObjectMatcher.DistanceFunction)EditionDistance.builder(left, right).build());
        DefaultComparisonFactory comparisonFactory = new DefaultComparisonFactory((IEqualityHelperFactory)new DefaultEqualityHelperFactory());
        DefaultMatchEngine matchEngine = new DefaultMatchEngine((IEObjectMatcher)matcher, (IComparisonFactory)comparisonFactory);
        return EMFCompareUtils.createMatchEngineRegistryFromMatchEngine((IMatchEngine)matchEngine);
    }

    private static IMatchEngine.Factory.Registry createMatchEngineRegistryFromMatchEngine(final IMatchEngine matchEngineToUse) {
        MatchEngineFactoryRegistryImpl matchEngineFactoryRegistry = new MatchEngineFactoryRegistryImpl();
        MatchEngineFactoryImpl matchEngineFactory = new MatchEngineFactoryImpl(){

            public IMatchEngine getMatchEngine() {
                return matchEngineToUse;
            }

            public boolean isMatchEngineFactoryFor(IComparisonScope scope) {
                return true;
            }
        };
        matchEngineFactoryRegistry.add((IMatchEngine.Factory)matchEngineFactory);
        return matchEngineFactoryRegistry;
    }
}

