/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.ide.repository;

import com.google.common.base.Predicate;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryClient;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryStructurer;
import org.eclipse.mylyn.docs.intent.collab.ide.adapters.WorkspaceAdapter;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceConfig;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceRepositoryLoader;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceSession;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;

public class WorkspaceRepository
implements Repository {
    private static final String WORKSPACE_RESOURCE_EXTENSION = "repomodel";
    private WorkspaceConfig workspaceConfig;
    private WorkspaceSession session;
    private boolean isResourceSetLoaded;
    private TransactionalEditingDomain editingDomain;
    private RepositoryStructurer repositoryStructurer;
    private EClass[] unloadableTypes;

    public WorkspaceRepository(WorkspaceConfig workspaceConfig, EClass ... unloadableTypes) {
        this.unloadableTypes = unloadableTypes;
        this.workspaceConfig = workspaceConfig;
        this.editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        this.isResourceSetLoaded = false;
    }

    private void initializeResourceSet() throws CoreException {
        IProject project = this.workspaceConfig.getProject();
        if (!project.exists()) {
            project.create(null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        IFolder folder = project.getFolder(this.workspaceConfig.getRepositoryRelativePath());
        WorkspaceRepositoryLoader loader = new WorkspaceRepositoryLoader(this, this.getWorkspaceConfig().getIndexesPathList());
        if (folder.exists()) {
            loader.loadResourceSet();
        } else {
            folder.create(0, true, null);
        }
        this.isResourceSetLoaded = true;
    }

    public void register(RepositoryClient client) {
    }

    public void unregister(RepositoryClient client) {
    }

    public synchronized Object getOrCreateSession() throws RepositoryConnectionException {
        if (!this.isResourceSetLoaded) {
            try {
                this.initializeResourceSet();
            }
            catch (CoreException e) {
                throw new RepositoryConnectionException(e.getMessage());
            }
        }
        if (this.session == null) {
            this.session = new WorkspaceSession(this);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener((IResourceChangeListener)this.session);
        }
        return this.session;
    }

    public synchronized void closeSession() throws RepositoryConnectionException {
        if (this.session != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.session);
            this.session.close();
            this.session = null;
        }
        if (((InternalTransactionalEditingDomain)this.editingDomain).getActiveTransaction() != null) {
            ((InternalTransactionalEditingDomain)this.editingDomain).getActiveTransaction().abort(Status.CANCEL_STATUS);
        }
        this.editingDomain.dispose();
    }

    public EPackage.Registry getPackageRegistry() throws RepositoryConnectionException {
        return this.getResourceSet().getPackageRegistry();
    }

    public boolean isInRepositoryPath(String path) {
        return path.startsWith(this.workspaceConfig.getRepositoryRelativePath());
    }

    public boolean isIncludedInPath(String path, Resource resource) {
        URI uriPath = this.getURIMatchingPath(path);
        return resource.getURI().toString().startsWith(uriPath.toString());
    }

    public URI getURIMatchingPath(String path) {
        String completePath = String.valueOf(this.getWorkspaceConfig().getRepositoryAbsolutePath()) + path;
        if (this.shouldHaveWorkspaceResourceExtension(completePath)) {
            completePath = String.valueOf(completePath) + ".repomodel";
        }
        completePath = completePath.trim();
        URI uri = URI.createPlatformResourceURI((String)completePath, (boolean)false);
        return uri;
    }

    public boolean shouldHaveWorkspaceResourceExtension(String path) {
        return !path.endsWith("/");
    }

    public ResourceSet getResourceSet() {
        return this.editingDomain.getResourceSet();
    }

    public WorkspaceConfig getWorkspaceConfig() {
        return this.workspaceConfig;
    }

    public static String getWorkspaceResourceExtension() {
        return WORKSPACE_RESOURCE_EXTENSION;
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setRepositoryStructurer(RepositoryStructurer structurer) {
        this.repositoryStructurer = structurer;
    }

    public RepositoryAdapter createRepositoryAdapter() {
        WorkspaceAdapter workspaceAdapter = new WorkspaceAdapter(this);
        if (this.repositoryStructurer != null) {
            workspaceAdapter.attachRepositoryStructurer(this.repositoryStructurer);
        }
        workspaceAdapter.setUnloadableResourcePredicate(new Predicate<Resource>(){

            public boolean apply(Resource resource) {
                if (!resource.getContents().isEmpty()) {
                    boolean res = false;
                    EObject root = (EObject)resource.getContents().iterator().next();
                    EClass[] eClassArray = WorkspaceRepository.this.unloadableTypes;
                    int n = eClassArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EClass unloadableType = eClassArray[n2];
                        if (root.eClass().equals(unloadableType)) {
                            res = true;
                        }
                        ++n2;
                    }
                    return res;
                }
                return false;
            }
        });
        return workspaceAdapter;
    }

    public String getIdentifier() {
        return this.workspaceConfig.getProject().getName();
    }

    public String getRepositoryLocation() {
        return String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toPortableString()) + this.getWorkspaceConfig().getRepositoryAbsolutePath().replace(".repository", "");
    }

    public URI getRepositoryURI() {
        return URI.createPlatformResourceURI((String)this.getIdentifier(), (boolean)true);
    }
}

