/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.exporter.ui.popup.actions;

import java.io.File;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.exporter.api.IntentHTMLExporter;

public class ExportIntentDocumentationJob
extends Job {
    private static final String JOB_NAME = "Exporting documentation as HTML";
    private IntentStructuredElement intentElementToExport;
    private IProject project;
    private String targetFolderLocation;
    private String exportedIntentDocumentName;
    private boolean shouldShowTableOfContent;

    public ExportIntentDocumentationJob(IntentStructuredElement intentElementToExport, IProject project, String targetFolderLocation, String exportedIntentDocumentName, boolean shouldShowtableOfContent) {
        super(JOB_NAME);
        this.intentElementToExport = intentElementToExport;
        this.project = project;
        this.targetFolderLocation = targetFolderLocation;
        this.exportedIntentDocumentName = exportedIntentDocumentName;
        this.shouldShowTableOfContent = shouldShowtableOfContent;
    }

    protected IStatus run(IProgressMonitor monitor) {
        new IntentHTMLExporter().exportIntentDocumentation(this.intentElementToExport, this.targetFolderLocation, this.exportedIntentDocumentName, this.shouldShowTableOfContent, BasicMonitor.toMonitor((IProgressMonitor)monitor));
        File targetFolder = new File(this.targetFolderLocation);
        String projectRelativePath = targetFolder.getAbsolutePath().toString().replace(new File(this.project.getLocationURI()).getAbsolutePath().toString(), "").substring(1);
        IFolder targetFolderInWorkspace = this.project.getFolder((IPath)new Path(projectRelativePath));
        try {
            if (targetFolderInWorkspace.exists()) {
                targetFolderInWorkspace.refreshLocal(2, null);
            } else {
                this.project.refreshLocal(2, null);
            }
        }
        catch (CoreException e) {
            IntentUiLogger.logError((Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

