/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.core.compiler;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SynchronizerChangeState implements Enumerator
{
    UPDATE(0, "UPDATE", "UPDATE"),
    ORDER(1, "ORDER", "ORDER"),
    WORKING_COPY_TARGET(2, "WORKING_COPY_TARGET", "WORKING_COPY_TARGET"),
    COMPILED_TARGET(3, "COMPILED_TARGET", "COMPILED_TARGET");

    public static final int UPDATE_VALUE = 0;
    public static final int ORDER_VALUE = 1;
    public static final int WORKING_COPY_TARGET_VALUE = 2;
    public static final int COMPILED_TARGET_VALUE = 3;
    private static final SynchronizerChangeState[] VALUES_ARRAY;
    public static final List<SynchronizerChangeState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SynchronizerChangeState[]{UPDATE, ORDER, WORKING_COPY_TARGET, COMPILED_TARGET};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SynchronizerChangeState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SynchronizerChangeState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SynchronizerChangeState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SynchronizerChangeState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SynchronizerChangeState get(int value) {
        switch (value) {
            case 0: {
                return UPDATE;
            }
            case 1: {
                return ORDER;
            }
            case 2: {
                return WORKING_COPY_TARGET;
            }
            case 3: {
                return COMPILED_TARGET;
            }
        }
        return null;
    }

    private SynchronizerChangeState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

