/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.cdo.launcher;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.mylyn.docs.intent.client.compiler.launcher.CompilerCreator;
import org.eclipse.mylyn.docs.intent.client.compiler.repositoryconnection.CompilerRepositoryClient;
import org.eclipse.mylyn.docs.intent.client.indexer.IndexerRepositoryClient;
import org.eclipse.mylyn.docs.intent.client.linkresolver.repository.LinkResolverClient;
import org.eclipse.mylyn.docs.intent.client.linkresolver.repository.LinkResolverCreator;
import org.eclipse.mylyn.docs.intent.client.synchronizer.SynchronizerCreator;
import org.eclipse.mylyn.docs.intent.client.synchronizer.SynchronizerRepositoryClient;
import org.eclipse.mylyn.docs.intent.client.synchronizer.listeners.GeneratedElementListener;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.repository.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;

public final class IntentCDOManager {
    private static Map<String, IntentCDOManager> cdoManagers = Maps.newLinkedHashMap();
    private Repository repository;
    private CompilerRepositoryClient compilerClient;
    private SynchronizerRepositoryClient synchronizerClient;
    private IndexerRepositoryClient indexerClient;
    private LinkResolverClient linkResolverClient;
    private String repositoryLocation;
    private boolean isConnected;

    private IntentCDOManager(String repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
    }

    private void connect() throws RepositoryConnectionException {
        if (!this.isConnected) {
            try {
                this.repository = IntentRepositoryManager.INSTANCE.getRepository(this.repositoryLocation);
                IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[IntentProjectManager] Connecting to project " + this.repositoryLocation);
                if (this.repository == null) {
                    throw new RepositoryConnectionException("Cannot create Repository on project " + this.repositoryLocation);
                }
                this.repository.getOrCreateSession();
            }
            catch (CoreException e) {
                throw new RepositoryConnectionException(e.getMessage());
            }
            this.isConnected = true;
        }
    }

    public void initializeClients() throws RepositoryConnectionException, ReadOnlyException {
        this.connect();
        if (this.compilerClient == null) {
            this.compilerClient = CompilerCreator.createCompilerClient((Repository)this.repository);
        }
        if (this.linkResolverClient == null) {
            this.linkResolverClient = LinkResolverCreator.createLinkResolverClient((Repository)this.repository);
        }
        if (this.synchronizerClient == null) {
            this.synchronizerClient = SynchronizerCreator.createSynchronizer((Repository)this.repository, (GeneratedElementListener)new GeneratedElementListener(){

                public void setSynchronizer(SynchronizerRepositoryClient synchronizer) {
                }

                public void removeElementToListen(URI uri) {
                }

                public void notifySynchronizer(URI uriOfChangedElement) {
                }

                public void dispose() {
                }

                public void clearElementToListen() {
                }

                public void addElementToListen(URI uri) {
                }
            });
        }
        this.compilerClient.handleChangeNotification(null);
        this.linkResolverClient.handleChangeNotification(null);
    }

    public static IntentCDOManager getCDOManager(String repositoryLocation) {
        IntentCDOManager projectManager = cdoManagers.get(repositoryLocation);
        if (projectManager == null) {
            projectManager = new IntentCDOManager(repositoryLocation);
            cdoManagers.put(repositoryLocation, projectManager);
        }
        return projectManager;
    }
}

