/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.bridge.java.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.mylyn.docs.intent.bridge.java.AbstractCapableElement;
import org.eclipse.mylyn.docs.intent.bridge.java.Classifier;
import org.eclipse.mylyn.docs.intent.bridge.java.ClassifierKind;
import org.eclipse.mylyn.docs.intent.bridge.java.Constructor;
import org.eclipse.mylyn.docs.intent.bridge.java.DocumentedElement;
import org.eclipse.mylyn.docs.intent.bridge.java.Field;
import org.eclipse.mylyn.docs.intent.bridge.java.JavaFactory;
import org.eclipse.mylyn.docs.intent.bridge.java.JavaPackage;
import org.eclipse.mylyn.docs.intent.bridge.java.Javadoc;
import org.eclipse.mylyn.docs.intent.bridge.java.Method;
import org.eclipse.mylyn.docs.intent.bridge.java.NamedElement;
import org.eclipse.mylyn.docs.intent.bridge.java.Parameter;
import org.eclipse.mylyn.docs.intent.bridge.java.VisibilityKind;
import org.eclipse.mylyn.docs.intent.bridge.java.VisibleElement;
import org.eclipse.mylyn.docs.intent.bridge.java.impl.AbstractCapableElementImpl;
import org.eclipse.mylyn.docs.intent.bridge.java.impl.ClassifierImpl;
import org.eclipse.mylyn.docs.intent.bridge.java.impl.ConstructorImpl;
import org.eclipse.mylyn.docs.intent.bridge.java.impl.DocumentedElementImpl;
import org.eclipse.mylyn.docs.intent.bridge.java.impl.FieldImpl;
import org.eclipse.mylyn.docs.intent.bridge.java.impl.JavadocImpl;
import org.eclipse.mylyn.docs.intent.bridge.java.impl.MethodImpl;
import org.eclipse.mylyn.docs.intent.bridge.java.impl.NamedElementImpl;
import org.eclipse.mylyn.docs.intent.bridge.java.impl.ParameterImpl;
import org.eclipse.mylyn.docs.intent.bridge.java.impl.VisibleElementImpl;

public class JavaFactoryImpl
extends EFactoryImpl
implements JavaFactory {
    public static JavaFactory init() {
        try {
            JavaFactory theJavaFactory = (JavaFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/intent/bridges/java/0.8");
            if (theJavaFactory != null) {
                return theJavaFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new JavaFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createJavadoc();
            }
            case 1: {
                return this.createDocumentedElement();
            }
            case 2: {
                return this.createNamedElement();
            }
            case 3: {
                return this.createVisibleElement();
            }
            case 4: {
                return this.createAbstractCapableElement();
            }
            case 5: {
                return this.createField();
            }
            case 6: {
                return this.createClassifier();
            }
            case 7: {
                return this.createMethod();
            }
            case 8: {
                return this.createConstructor();
            }
            case 9: {
                return this.createParameter();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 10: {
                return this.createVisibilityKindFromString(eDataType, initialValue);
            }
            case 11: {
                return this.createClassifierKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 10: {
                return this.convertVisibilityKindToString(eDataType, instanceValue);
            }
            case 11: {
                return this.convertClassifierKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Javadoc createJavadoc() {
        JavadocImpl javadoc = new JavadocImpl();
        return javadoc;
    }

    public DocumentedElement createDocumentedElement() {
        DocumentedElementImpl documentedElement = new DocumentedElementImpl();
        return documentedElement;
    }

    public NamedElement createNamedElement() {
        NamedElementImpl namedElement = new NamedElementImpl();
        return namedElement;
    }

    public VisibleElement createVisibleElement() {
        VisibleElementImpl visibleElement = new VisibleElementImpl();
        return visibleElement;
    }

    public AbstractCapableElement createAbstractCapableElement() {
        AbstractCapableElementImpl abstractCapableElement = new AbstractCapableElementImpl();
        return abstractCapableElement;
    }

    public Field createField() {
        FieldImpl field = new FieldImpl();
        return field;
    }

    public Classifier createClassifier() {
        ClassifierImpl classifier = new ClassifierImpl();
        return classifier;
    }

    public Method createMethod() {
        MethodImpl method = new MethodImpl();
        return method;
    }

    public Constructor createConstructor() {
        ConstructorImpl constructor = new ConstructorImpl();
        return constructor;
    }

    public Parameter createParameter() {
        ParameterImpl parameter = new ParameterImpl();
        return parameter;
    }

    public VisibilityKind createVisibilityKindFromString(EDataType eDataType, String initialValue) {
        VisibilityKind result = VisibilityKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertVisibilityKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ClassifierKind createClassifierKindFromString(EDataType eDataType, String initialValue) {
        ClassifierKind result = ClassifierKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertClassifierKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public JavaPackage getJavaPackage() {
        return (JavaPackage)this.getEPackage();
    }

    @Deprecated
    public static JavaPackage getPackage() {
        return JavaPackage.eINSTANCE;
    }
}

