/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorInput;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.query.IntentDocumentQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.query.IntentHelper;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public final class IntentEditorOpener {
    private IntentEditorOpener() {
    }

    public static void openIntentEditor(Repository repository, boolean readOnlyMode) {
        try {
            RepositoryAdapter repositoryAdapter = repository.createRepositoryAdapter();
            IntentEditorOpener.openContext(repositoryAdapter, readOnlyMode);
            IntentDocument elementToOpen = new IntentDocumentQuery(repositoryAdapter).getOrCreateIntentDocument();
            IntentEditorOpener.openIntentEditor(repositoryAdapter, (EObject)elementToOpen, false, (EObject)elementToOpen, false);
        }
        catch (PartInitException e) {
            IntentUiLogger.logError(e);
        }
    }

    public static void openIntentEditor(Repository repository, EObject elementToOpen, boolean readOnlyMode, EObject elementToSelectRangeWith, boolean forceNewEditor) {
        try {
            RepositoryAdapter repositoryAdapter = repository.createRepositoryAdapter();
            IntentEditorOpener.openIntentEditor(repositoryAdapter, elementToOpen, false, elementToSelectRangeWith, forceNewEditor);
        }
        catch (PartInitException e) {
            IntentUiLogger.logError(e);
        }
    }

    private static IntentEditor openIntentEditor(RepositoryAdapter repositoryAdapter, EObject elementToOpen, boolean readOnlyMode, EObject elementToSelectRangeWith, boolean forceNewEditor) throws PartInitException {
        IntentEditor editor;
        IntentEditor openedEditor = null;
        Status status = null;
        IntentEditorOpener.openContext(repositoryAdapter, readOnlyMode);
        EObject elementToOpenLoadedFromAdapter = repositoryAdapter.getElementWithID(repositoryAdapter.getIDFromElement(elementToOpen));
        EObject elementToSelectRangeWithLoadedFromAdapter = repositoryAdapter.getElementWithID(repositoryAdapter.getIDFromElement(elementToSelectRangeWith));
        boolean foundInAlreadyExistingEditor = false;
        if (!forceNewEditor && (editor = IntentEditorOpener.getAlreadyOpenedEditor(elementToOpenLoadedFromAdapter)) != null) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
            openedEditor = editor;
            foundInAlreadyExistingEditor = editor.selectRange((IntentGenericElement)elementToSelectRangeWithLoadedFromAdapter);
        }
        if (openedEditor == null || !foundInAlreadyExistingEditor) {
            IWorkbenchPage page = null;
            try {
                page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                openedEditor = IntentEditorOpener.openEditor(repositoryAdapter, page, elementToOpenLoadedFromAdapter);
                if (elementToSelectRangeWithLoadedFromAdapter != elementToOpenLoadedFromAdapter) {
                    openedEditor.selectRange((IntentGenericElement)elementToSelectRangeWithLoadedFromAdapter);
                }
            }
            catch (NullPointerException nullPointerException) {
                status = new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", "An unexpected error has occured");
                throw new PartInitException((IStatus)status);
            }
        }
        return openedEditor;
    }

    private static void openContext(RepositoryAdapter repositoryAdapter, boolean readOnlyMode) {
        if (repositoryAdapter.getContext() == null) {
            boolean isReadOnly = readOnlyMode;
            if (!readOnlyMode) {
                try {
                    repositoryAdapter.openSaveContext();
                }
                catch (ReadOnlyException readOnlyException) {
                    IntentLogger.getInstance().log(IIntentLogger.LogType.WARNING, "The Intent Editor has insufficient rights (read-only) to save modifications on the repository. A read-only context will be used instead.");
                    isReadOnly = true;
                }
            }
            if (isReadOnly) {
                repositoryAdapter.openReadOnlyContext();
            }
        }
    }

    public static IntentEditor getAlreadyOpenedEditor(EObject elementToOpen) {
        IntentEditor alreadyOpenedEditor = null;
        IWorkbenchPage activePage = null;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            activePage = activeWorkbenchWindow.getActivePage();
        }
        if (activePage != null) {
            IEditorReference[] editorReferences = activePage.getEditorReferences();
            int editorCount = 0;
            while (editorCount < editorReferences.length && alreadyOpenedEditor == null) {
                IEditorReference editorReference = editorReferences[editorCount];
                IEditorPart editor = editorReference.getEditor(false);
                if (editor instanceof IntentEditor && ((IntentEditor)editor).containsElement((IntentGenericElement)elementToOpen)) {
                    alreadyOpenedEditor = (IntentEditor)editor;
                    activePage.activate((IWorkbenchPart)alreadyOpenedEditor);
                }
                ++editorCount;
            }
        }
        return alreadyOpenedEditor;
    }

    private static IntentEditor openEditor(RepositoryAdapter repositoryAdapter, IWorkbenchPage page, Object intentElementToOpen) throws PartInitException {
        boolean canBeOpenedByIntentEditor = IntentHelper.canBeOpenedByIntentEditor((Object)intentElementToOpen);
        EObject elementToOpen = null;
        if (intentElementToOpen instanceof EObject) {
            elementToOpen = (EObject)intentElementToOpen;
        }
        while (!canBeOpenedByIntentEditor && elementToOpen != null && !(elementToOpen instanceof Resource)) {
            elementToOpen = elementToOpen.eContainer();
            canBeOpenedByIntentEditor = IntentHelper.canBeOpenedByIntentEditor((Object)elementToOpen);
        }
        if (canBeOpenedByIntentEditor) {
            IntentEditorInput input = new IntentEditorInput(elementToOpen, repositoryAdapter);
            IEditorPart part = page.openEditor((IEditorInput)input, "org.eclipse.mylyn.docs.intent.client.ui.IntentEditor");
            if (part instanceof IntentEditor) {
                return (IntentEditor)part;
            }
            Status status = new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", "cannot open the editor");
            throw new PartInitException((IStatus)status);
        }
        IntentUiLogger.logError("this element is not a correct Intent element", new PartInitException("Invalid element : must be a Intent Element"));
        Status status = new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", "this element is not a correct Intent element");
        throw new PartInitException((IStatus)status);
    }
}

