/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler.validator;

import java.util.HashMap;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.CompilationException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.ValidationException;
import org.eclipse.mylyn.docs.intent.client.compiler.validator.LabelProviderForValidator;
import org.eclipse.mylyn.docs.intent.core.document.UnitInstruction;

public class GeneratedElementValidator {
    private EObject elementToValidate;
    private UnitInstruction instruction;

    public GeneratedElementValidator(UnitInstruction instruction, EObject generatedElement) {
        this.instruction = instruction;
        this.elementToValidate = generatedElement;
    }

    public Diagnostic validate() throws CompilationException {
        HashMap<Class<EValidator.SubstitutionLabelProvider>, LabelProviderForValidator> contextEntries = new HashMap<Class<EValidator.SubstitutionLabelProvider>, LabelProviderForValidator>();
        contextEntries.put(EValidator.SubstitutionLabelProvider.class, new LabelProviderForValidator());
        Diagnostic diagnostic = null;
        try {
            diagnostic = Diagnostician.INSTANCE.validate(this.elementToValidate, contextEntries);
            if (diagnostic.getSeverity() > 0) {
                throw new ValidationException(this.instruction, ValidationException.getErrorMessageFrom(this.elementToValidate, diagnostic));
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new ValidationException(this.instruction, "An unexpected error occured during validation of this element.");
        }
        return diagnostic;
    }
}

