/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.outline;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.IntentOutlineInformationHolder;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionBloc;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstructionReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.NewObjectValue;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;
import org.eclipse.mylyn.docs.intent.markup.markup.Text;

public class OutlineContentProvider
extends AdapterFactoryContentProvider {
    private boolean hideDescriptionUnitsContent;
    private Object rootElement;

    public OutlineContentProvider(AdapterFactory adapterFactory, Object rootElement) {
        this(adapterFactory, rootElement, false);
    }

    public OutlineContentProvider(AdapterFactory adapterFactory, Object rootElement, boolean hideDescriptionUnitsContent) {
        super(adapterFactory);
        this.hideDescriptionUnitsContent = hideDescriptionUnitsContent;
        this.rootElement = rootElement;
    }

    public Object[] getChildren(Object object) {
        LinkedHashSet<Object> children = new LinkedHashSet<Object>();
        if (!this.filter(object)) {
            if (object instanceof ResourceDeclaration) {
                ResourceDeclaration resourceDeclaration = (ResourceDeclaration)object;
                for (ModelingUnitInstructionReference root : resourceDeclaration.getContent()) {
                    children.add(root);
                }
            }
            if (!this.filter(object)) {
                EObject element = (EObject)object;
                for (EObject containedElement : element.eContents()) {
                    if (this.filter(containedElement)) continue;
                    children.add(this.getValueForChildren((IntentGenericElement)containedElement));
                }
            }
        }
        return children.toArray();
    }

    private boolean filter(Object object) {
        boolean hasToBeFiltered;
        boolean bl = hasToBeFiltered = !(object instanceof IntentGenericElement);
        if (this.hideDescriptionUnitsContent) {
            hasToBeFiltered = hasToBeFiltered || object instanceof DescriptionBloc || object instanceof Text;
        }
        return hasToBeFiltered;
    }

    private EObject getValueForChildren(IntentGenericElement children) {
        Object valueForChildren = null;
        valueForChildren = children instanceof NewObjectValue ? ((NewObjectValue)children).getValue() : children;
        return valueForChildren;
    }

    public Object[] getElements(Object object) {
        IntentOutlineInformationHolder informationHolder;
        LinkedHashSet<EObject> children = new LinkedHashSet<EObject>();
        if (object instanceof IntentOutlineInformationHolder && (informationHolder = (IntentOutlineInformationHolder)object).isRoot()) {
            children.add(informationHolder.getElement());
        }
        if (object instanceof IntentStructuredElement) {
            EObject element = (EObject)object;
            for (EObject containedElement : element.eContents()) {
                if (this.filter(containedElement)) continue;
                children.add(containedElement);
            }
        }
        return children.toArray();
    }

    public boolean hasChildren(Object object) {
        boolean hasChildren = false;
        if (!this.filter(object)) {
            if (object instanceof ResourceDeclaration && !(object instanceof ExternalContentReference)) {
                hasChildren = true;
            }
            Iterator contentIterator = ((EObject)object).eContents().iterator();
            while (!hasChildren && contentIterator.hasNext()) {
                boolean bl = hasChildren = !this.filter(contentIterator.next());
            }
        }
        return hasChildren;
    }

    public void notifyChanged(Notification notification) {
    }

    public Object getParent(Object object) {
        if (object == this.rootElement) {
            return null;
        }
        return super.getParent(object);
    }
}

