/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.bridge.java.resource.factory;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.mylyn.docs.intent.bridge.java.AbstractCapableElement;
import org.eclipse.mylyn.docs.intent.bridge.java.Classifier;
import org.eclipse.mylyn.docs.intent.bridge.java.ClassifierKind;
import org.eclipse.mylyn.docs.intent.bridge.java.Field;
import org.eclipse.mylyn.docs.intent.bridge.java.JavaFactory;
import org.eclipse.mylyn.docs.intent.bridge.java.Javadoc;
import org.eclipse.mylyn.docs.intent.bridge.java.Method;
import org.eclipse.mylyn.docs.intent.bridge.java.Parameter;
import org.eclipse.mylyn.docs.intent.bridge.java.VisibilityKind;
import org.eclipse.mylyn.docs.intent.bridge.java.VisibleElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassExplorer {
    public Collection<Classifier> getJavaClassAsModel(ICompilationUnit javaClass) throws JavaModelException {
        IType[] allTypes;
        LinkedHashSet<Classifier> eClassifiers = new LinkedHashSet<Classifier>();
        IType[] iTypeArray = allTypes = javaClass.getAllTypes();
        int n = allTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType iType = iTypeArray[n2];
            eClassifiers.add(this.getTypeAsModel(iType));
            ++n2;
        }
        return eClassifiers;
    }

    private Classifier getTypeAsModel(IType iType) throws JavaModelException {
        Classifier eClassifier = JavaFactory.eINSTANCE.createClassifier();
        eClassifier.setName(iType.getFullyQualifiedName());
        this.updateAbstractInformations(eClassifier, (IMember)iType);
        this.updateVisibilityInformations(eClassifier, (IMember)iType);
        eClassifier.setJavadoc(this.getJavadocAsModel((IMember)iType));
        int flags = iType.getFlags();
        if (Flags.isInterface((int)flags)) {
            eClassifier.setKind(ClassifierKind.INTERFACE);
        } else if (Flags.isEnum((int)flags)) {
            eClassifier.setKind(ClassifierKind.ENUM);
        } else {
            eClassifier.setKind(ClassifierKind.CLASS);
        }
        eClassifier.setExtends(iType.getSuperclassName());
        String[] stringArray = iType.getSuperInterfaceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String superInterface = stringArray[n2];
            eClassifier.getImplements().add((Object)superInterface);
            ++n2;
        }
        stringArray = iType.getFields();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            eClassifier.getFields().add((Object)this.getFieldAsModel((IField)field));
            ++n2;
        }
        stringArray = iType.getMethods();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String method = stringArray[n2];
            eClassifier.getMethods().add((Object)this.getMethodAsModel((IMethod)method));
            ++n2;
        }
        return eClassifier;
    }

    private Method getMethodAsModel(IMethod method) throws JavaModelException {
        Method eMethod = null;
        eMethod = method.isConstructor() ? JavaFactory.eINSTANCE.createConstructor() : JavaFactory.eINSTANCE.createMethod();
        JavaFactory.eINSTANCE.createMethod();
        eMethod.setSimpleName(method.getElementName());
        this.updateAbstractInformations(eMethod, (IMember)method);
        this.updateVisibilityInformations(eMethod, (IMember)method);
        eMethod.setJavadoc(this.getJavadocAsModel((IMember)method));
        eMethod.setReturnType(JavaClassExplorer.getTypeFromTypeSignature(method.getReturnType()));
        Object[] objectArray = method.getParameters();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalVariable parameter = objectArray[n2];
            Parameter eParameter = JavaFactory.eINSTANCE.createParameter();
            eParameter.setName(parameter.getElementName());
            eParameter.setType(JavaClassExplorer.getTypeFromTypeSignature(parameter.getTypeSignature()));
            String attachedJavadoc = parameter.getAttachedJavadoc((IProgressMonitor)new NullProgressMonitor());
            if (attachedJavadoc != null && attachedJavadoc.length() > 0) {
                Javadoc paramJavaDoc = JavaFactory.eINSTANCE.createJavadoc();
                paramJavaDoc.setContent(attachedJavadoc);
                eParameter.setJavadoc(paramJavaDoc);
            }
            eMethod.getParameters().add((Object)eParameter);
            ++n2;
        }
        objectArray = method.getExceptionTypes();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            ILocalVariable exceptionType = objectArray[n2];
            eMethod.getExceptions().add((Object)JavaClassExplorer.getTypeFromTypeSignature((String)exceptionType));
            ++n2;
        }
        String methodContentWithoutJavaDoc = method.getSource();
        if (methodContentWithoutJavaDoc.contains("{") && methodContentWithoutJavaDoc.contains("}")) {
            if (method.getJavadocRange() != null) {
                methodContentWithoutJavaDoc = method.getSource().substring(method.getJavadocRange().getLength());
            }
            String methodContentWithoutDeclaration = methodContentWithoutJavaDoc.trim();
            methodContentWithoutDeclaration = methodContentWithoutJavaDoc.substring(methodContentWithoutJavaDoc.indexOf("{") + 1);
            methodContentWithoutDeclaration = methodContentWithoutDeclaration.substring(0, methodContentWithoutDeclaration.lastIndexOf("}")).trim();
            String methodContent = "";
            String[] methodLines = methodContentWithoutDeclaration.split("\n");
            int i = 0;
            while (i < methodLines.length) {
                methodContent = String.valueOf(methodContent) + methodLines[i].trim().replace("\t", "") + "\n";
                ++i;
            }
            methodContent = methodContent.trim();
            eMethod.setContent(methodContent);
        }
        eMethod.setName(JavaClassExplorer.getMethodID(method));
        return eMethod;
    }

    private Field getFieldAsModel(IField field) throws JavaModelException {
        Field eField = JavaFactory.eINSTANCE.createField();
        eField.setName(field.getElementName());
        eField.setJavadoc(this.getJavadocAsModel((IMember)field));
        eField.setType(JavaClassExplorer.getTypeFromTypeSignature(field.getTypeSignature()));
        this.updateVisibilityInformations(eField, (IMember)field);
        return eField;
    }

    private Javadoc getJavadocAsModel(IMember iMember) throws JavaModelException {
        Javadoc eJavaDoc = null;
        if (iMember.getJavadocRange() != null) {
            eJavaDoc = JavaFactory.eINSTANCE.createJavadoc();
            eJavaDoc.setContent(iMember.getOpenable().getBuffer().getText(iMember.getJavadocRange().getOffset(), iMember.getJavadocRange().getLength()));
        }
        return eJavaDoc;
    }

    private void updateAbstractInformations(AbstractCapableElement abstactCapableElement, IMember iMember) throws JavaModelException {
        abstactCapableElement.setAbstract(Flags.isAbstract((int)iMember.getFlags()));
    }

    private void updateVisibilityInformations(VisibleElement visiblementElement, IMember iMember) throws JavaModelException {
        int flags = iMember.getFlags();
        visiblementElement.setFinal(Flags.isFinal((int)flags));
        visiblementElement.setStatic(Flags.isStatic((int)flags));
        if (Flags.isPublic((int)flags)) {
            visiblementElement.setVisibility(VisibilityKind.PUBLIC);
        } else if (Flags.isProtected((int)flags)) {
            visiblementElement.setVisibility(VisibilityKind.PROTECTED);
        } else if (Flags.isPrivate((int)flags)) {
            visiblementElement.setVisibility(VisibilityKind.PRIVATE);
        } else {
            visiblementElement.setVisibility(VisibilityKind.PACKAGE);
        }
    }

    public static String getTypeFromTypeSignature(String typeSignature) {
        return Signature.toString((String)typeSignature);
    }

    public static String getMemberID(IMember member) throws JavaModelException {
        if (member instanceof IMethod) {
            return JavaClassExplorer.getMethodID((IMethod)member);
        }
        return member.getElementName();
    }

    public static String getMethodID(IMethod method) throws JavaModelException {
        String methodSignature = String.valueOf(method.getElementName()) + "(";
        ILocalVariable[] iLocalVariableArray = method.getParameters();
        int n = iLocalVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalVariable parameter = iLocalVariableArray[n2];
            methodSignature = String.valueOf(methodSignature) + "," + JavaClassExplorer.getTypeFromTypeSignature(parameter.getTypeSignature());
            ++n2;
        }
        methodSignature = String.valueOf(methodSignature.replaceFirst(",", "")) + ")";
        return methodSignature;
    }
}

