/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorDocument;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorInput;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotationModelManager;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.image.IntentImageAnnotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.image.IntentImageAnnotationDisposer;
import org.eclipse.mylyn.docs.intent.client.ui.editor.scanner.IntentPartitionScanner;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.client.ui.repositoryconnection.EditorElementListAdapter;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.handlers.ReadWriteRepositoryObjectHandler;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryClient;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryObjectHandler;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.SaveException;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.ReadOnlyRepositoryObjectHandlerImpl;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.ReadWriteRepositoryObjectHandlerImpl;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.notification.elementList.ElementListAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.notification.elementList.ElementListNotificator;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.notification.typeListener.TypeNotificator;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.Notificator;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotification;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.compare.IntentASTMerger;
import org.eclipse.mylyn.docs.intent.compare.MergingException;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusManager;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusSeverity;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerPackage;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.genericunit.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference;
import org.eclipse.mylyn.docs.intent.core.query.IntentHelper;
import org.eclipse.mylyn.docs.intent.parser.IntentParser;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.ParseException;
import org.eclipse.mylyn.docs.intent.serializer.ParsedElementPosition;
import org.eclipse.ui.internal.editors.text.WorkspaceOperationRunner;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class IntentDocumentProvider
extends AbstractDocumentProvider
implements RepositoryClient {
    private Repository repository;
    private RepositoryObjectHandler listenedElementsHandler;
    private Map<Object, List<IntentEditorDocument>> elementsToDocuments = new HashMap<Object, List<IntentEditorDocument>>();
    private EObject documentRoot;
    private WorkspaceOperationRunner fOperationRunner;
    private IntentEditor associatedEditor;
    private IntentAnnotationModelManager annotationModelManager;
    private IntentEditorDocument createdDocument;
    private IDocumentPartitioner partitioner;
    private boolean hasSyntaxErrors;

    public IntentDocumentProvider(IntentEditor editor) {
        this.associatedEditor = editor;
        this.annotationModelManager = new IntentAnnotationModelManager();
    }

    public boolean canSaveDocument(Object element) {
        return this.hasSyntaxErrors || super.canSaveDocument(element);
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        Assert.isNotNull((Object)this.annotationModelManager);
        for (CompilationStatus status : IntentHelper.getAllStatus((IntentGenericElement)((IntentGenericElement)this.documentRoot))) {
            List<IntentEditorDocument> list = this.elementsToDocuments.get(this.listenedElementsHandler.getRepositoryAdapter().getIDFromElement((EObject)status.getTarget()));
            if (list == null) continue;
            IntentEditorDocument doc = list.get(0);
            ParsedElementPosition posit = doc.getIntentPosition((EObject)status.getTarget());
            if (posit == null) {
                posit = new ParsedElementPosition(0, 0);
            }
            if (status.getSeverity().equals((Object)CompilationStatusSeverity.INFO)) continue;
            this.annotationModelManager.addAnnotationFromStatus(this.listenedElementsHandler.getRepositoryAdapter(), status, new Position(posit.getOffset(), posit.getDeclarationLength()));
        }
        for (ExternalContentReference reference : IntentHelper.getAllExternalContentReferences((IntentGenericElement)((IntentGenericElement)this.documentRoot))) {
            this.annotationModelManager.updateAnnotationFromExternalContentReference(reference, this.createdDocument.getIntentPosition((EObject)reference));
        }
        this.annotationModelManager.getAnnotationModel().addAnnotationModelListener((IAnnotationModelListener)new IntentImageAnnotationDisposer());
        return this.annotationModelManager.getAnnotationModel();
    }

    public IAnnotationModel getAnnotationModel(Object element) {
        return this.annotationModelManager.getAnnotationModel();
    }

    protected IDocument createDocument(Object element) throws CoreException {
        if (!(element instanceof IntentEditorInput)) {
            Status status = new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", "Cannot open an Intent editor on a document of type " + element.getClass().getCanonicalName() + " (must be IntentEditorInput) ");
            throw new CoreException((IStatus)status);
        }
        if (((IntentEditorInput)((Object)element)).getRepository() == null) {
            Status status = new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", "Cannot open Intent editor : document is not available.");
            throw new CoreException((IStatus)status);
        }
        this.setRepository(((IntentEditorInput)((Object)element)).getRepository());
        this.documentRoot = ((IntentEditorInput)((Object)element)).getIntentElement();
        ((IntentEditorInput)((Object)element)).getRepositoryAdapter().execute(new IntentCommand(){

            public void execute() {
                IntentDocumentProvider.this.createdDocument = new IntentEditorDocument(IntentDocumentProvider.this.documentRoot, IntentDocumentProvider.this.associatedEditor);
            }
        });
        if (this.createdDocument != null) {
            this.partitioner = new FastPartitioner((IPartitionTokenScanner)new IntentPartitionScanner(), IntentPartitionScanner.LEGAL_CONTENT_TYPES);
            this.partitioner.connect((IDocument)this.createdDocument);
            this.createdDocument.setDocumentPartitioner(this.partitioner);
            this.subscribeRepository(((IntentEditorInput)((Object)element)).getRepositoryAdapter());
            this.addAllContentAsIntentElement(this.documentRoot, this.createdDocument);
        }
        return this.createdDocument;
    }

    private void subscribeRepository(RepositoryAdapter repositoryAdapter) {
        RepositoryObjectHandler elementHandler = IntentDocumentProvider.createElementHandler(repositoryAdapter, false);
        this.addRepositoryObjectHandler(elementHandler);
        LinkedHashSet<EObject> listenedObjects = new LinkedHashSet<EObject>();
        listenedObjects.add(this.documentRoot);
        EditorElementListAdapter adapter = new EditorElementListAdapter();
        ElementListNotificator listenedElementsNotificator = new ElementListNotificator(listenedObjects, (ElementListAdapter)adapter, repositoryAdapter);
        TypeNotificator compilationStatusNotificator = new TypeNotificator((Set)Sets.newLinkedHashSet((Iterable)CompilerPackage.eINSTANCE.getCompilationStatusManager().getEAllStructuralFeatures()));
        elementHandler.addNotificator((Notificator)listenedElementsNotificator);
        elementHandler.addNotificator((Notificator)compilationStatusNotificator);
    }

    private static RepositoryObjectHandler createElementHandler(RepositoryAdapter repositoryAdapter, boolean readOnlyMode) {
        boolean isReadOnly = readOnlyMode;
        ReadWriteRepositoryObjectHandlerImpl elementHandler = null;
        if (!isReadOnly) {
            try {
                elementHandler = new ReadWriteRepositoryObjectHandlerImpl(repositoryAdapter);
            }
            catch (ReadOnlyException readOnlyException) {
                IntentLogger.getInstance().log(IIntentLogger.LogType.WARNING, "The Intent Editor has insufficient rights (read-only) to save modifications on the repository. A read-only context will be used instead.");
                isReadOnly = true;
            }
        }
        if (isReadOnly) {
            elementHandler = new ReadOnlyRepositoryObjectHandlerImpl();
            elementHandler.setRepositoryAdapter(repositoryAdapter);
        }
        return elementHandler;
    }

    public void addAllContentAsIntentElement(EObject root, IntentEditorDocument document) {
        Object identifier = this.listenedElementsHandler.getRepositoryAdapter().getIDFromElement(root);
        if (this.elementsToDocuments.get(identifier) == null) {
            this.elementsToDocuments.put(identifier, new ArrayList());
        }
        if (!this.elementsToDocuments.get(identifier).contains((Object)document)) {
            this.elementsToDocuments.get(identifier).add(document);
        }
        for (EObject content : root.eContents()) {
            this.addAllContentAsIntentElement(content, document);
        }
    }

    public void refreshOutline(EObject newAST) {
        this.associatedEditor.refreshOutlineView(newAST);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, final IDocument document, boolean overwrite) throws CoreException {
        if (document instanceof IntentEditorDocument) {
            try {
                this.hasSyntaxErrors = false;
                this.removeSyntaxErrors();
                String rootCompleteLevel = null;
                if (this.documentRoot instanceof IntentStructuredElement) {
                    rootCompleteLevel = ((IntentStructuredElement)this.documentRoot).getCompleteLevel();
                }
                final EObject localAST = new IntentParser().parse(document.get(), rootCompleteLevel);
                this.associatedEditor.refreshTitle(localAST);
                final RepositoryAdapter repositoryAdapter = this.listenedElementsHandler.getRepositoryAdapter();
                repositoryAdapter.execute(new IntentCommand(){

                    public void execute() {
                        try {
                            IntentDocumentProvider.this.merge((IntentEditorDocument)document, localAST);
                            ((IntentEditorDocument)document).reloadFromAST(true);
                            repositoryAdapter.save();
                        }
                        catch (ReadOnlyException e) {
                            IntentUiLogger.logError(e);
                        }
                        catch (SaveException e) {
                            IntentUiLogger.logError(e);
                        }
                    }
                });
            }
            catch (ParseException e) {
                this.createSyntaxErrorAnnotation(e.getMessage(), e.getErrorOffset(), e.getErrorLength());
                this.hasSyntaxErrors = true;
            }
        }
    }

    private void merge(IntentEditorDocument document, EObject localAST) {
        IntentASTMerger merger = new IntentASTMerger();
        boolean mustUndo = false;
        try {
            EObject remoteAST = (EObject)document.getAST();
            try {
                if (localAST != null && remoteAST != null && localAST.eClass().equals(remoteAST.eClass())) {
                    merger.mergeFromLocalToRepository(localAST, remoteAST);
                } else {
                    this.createSyntaxErrorAnnotation("Unrecognized content: unable to merge " + localAST.eClass().getName() + " with " + remoteAST.eClass().getName() + ".", 0, document.getLength());
                }
            }
            catch (MergingException e) {
                mustUndo = true;
                IntentUiLogger.logError(e);
            }
            this.addAllContentAsIntentElement(this.documentRoot, document);
        }
        catch (NullPointerException npe) {
            mustUndo = true;
            IntentUiLogger.logError(npe);
        }
        if (mustUndo) {
            try {
                ((ReadWriteRepositoryObjectHandler)this.listenedElementsHandler).undo();
            }
            catch (ReadOnlyException e) {
                IntentUiLogger.logError(e);
            }
        }
    }

    public boolean isModifiable(Object element) {
        return true;
    }

    public boolean isReadOnly(Object element) {
        return false;
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        if (this.fOperationRunner == null) {
            this.fOperationRunner = new WorkspaceOperationRunner();
        }
        this.fOperationRunner.setProgressMonitor(monitor);
        return this.fOperationRunner;
    }

    public void handleChangeNotification(RepositoryChangeNotification notification) {
        if (this.handleRootHasBeenDeleted(notification)) {
            return;
        }
        for (EObject modifiedObject : notification.getImpactedElements()) {
            Object modifiedObjectIdentifier = this.listenedElementsHandler.getRepositoryAdapter().getIDFromElement(modifiedObject);
            if (this.elementsToDocuments.get(modifiedObjectIdentifier) != null) {
                this.handleContentHasChanged(modifiedObject, modifiedObjectIdentifier);
                continue;
            }
            this.handleCompilationStatusHasChanged(modifiedObject);
            for (ExternalContentReference reference : IntentHelper.getAllExternalContentReferences((IntentGenericElement)((IntentGenericElement)this.documentRoot))) {
                this.annotationModelManager.updateAnnotationFromExternalContentReference(reference, this.createdDocument.getIntentPosition((EObject)reference));
            }
        }
    }

    private void updateAnnotationModelFromCompilationStatusAndChildren(IntentGenericElement modifiedElement, IntentEditorDocument relatedDocument) {
        this.updateAnnotationModelFromCompilationStatus(modifiedElement, relatedDocument);
        TreeIterator eAllContents = modifiedElement.eAllContents();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            if (!(next instanceof IntentGenericElement)) continue;
            this.updateAnnotationModelFromCompilationStatus((IntentGenericElement)next, relatedDocument);
        }
    }

    private void updateAnnotationModelFromCompilationStatus(IntentGenericElement modifiedElement, IntentEditorDocument relatedDocument) {
        this.annotationModelManager.removeInvalidCompilerAnnotations(this.listenedElementsHandler.getRepositoryAdapter(), modifiedElement);
        for (CompilationStatus statusToAdd : modifiedElement.getCompilationStatus()) {
            ParsedElementPosition parsedElementPosition = relatedDocument.getIntentPosition((EObject)statusToAdd.getTarget());
            if (parsedElementPosition == null) {
                parsedElementPosition = new ParsedElementPosition(0, 0);
            }
            Position position = new Position(parsedElementPosition.getOffset(), parsedElementPosition.getDeclarationLength());
            if (statusToAdd.getSeverity().equals((Object)CompilationStatusSeverity.INFO)) continue;
            this.annotationModelManager.addAnnotationFromStatus(this.listenedElementsHandler.getRepositoryAdapter(), statusToAdd, position);
        }
    }

    public void addRepositoryObjectHandler(RepositoryObjectHandler handler) {
        handler.addClient((RepositoryClient)this);
        this.listenedElementsHandler = handler;
    }

    public void removeRepositoryObjectHandler(RepositoryObjectHandler handler) {
        handler.removeClient((RepositoryClient)this);
        this.listenedElementsHandler = null;
    }

    public RepositoryObjectHandler getListenedElementsHandler() {
        return this.listenedElementsHandler;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
        this.repository.register((RepositoryClient)this);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void close() {
        if (this.repository != null) {
            this.repository.unregister((RepositoryClient)this);
        }
        if (this.listenedElementsHandler != null) {
            this.listenedElementsHandler.getRepositoryAdapter().closeContext();
            this.listenedElementsHandler.removeClient((RepositoryClient)this);
            this.listenedElementsHandler.stop();
        }
        Iterator annotationIterator = this.annotationModelManager.getAnnotationModel().getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            Object annotation = annotationIterator.next();
            if (!(annotation instanceof IntentImageAnnotation)) continue;
            IntentImageAnnotationDisposer.disposeImage((IntentImageAnnotation)((Object)annotation));
        }
    }

    public void createSyntaxErrorAnnotation(String message, int offset, int length) {
        this.annotationModelManager.createSyntaxErrorAnnotation(message, offset, length);
    }

    public void removeSyntaxErrors() {
        this.annotationModelManager.removeSyntaxErrorsAnnotations();
    }

    public void dispose() {
        this.listenedElementsHandler.removeClient((RepositoryClient)this);
        this.listenedElementsHandler = null;
    }

    private boolean handleRootHasBeenDeleted(RepositoryChangeNotification notification) {
        if (notification.getImpactedElements().size() < 1) {
            Object modifiedObjectIdentifier = this.listenedElementsHandler.getRepositoryAdapter().getIDFromElement(this.documentRoot);
            if (this.elementsToDocuments.get(modifiedObjectIdentifier) != null) {
                for (IntentEditorDocument relatedDocument : this.elementsToDocuments.get(modifiedObjectIdentifier)) {
                    relatedDocument.unsynchronize();
                }
            }
            return true;
        }
        return false;
    }

    private void handleCompilationStatusHasChanged(EObject modifiedObject) {
        if (modifiedObject instanceof CompilationStatusManager && this.elementsToDocuments.values().iterator().hasNext() && this.elementsToDocuments.values().iterator().next().iterator().hasNext()) {
            this.updateAnnotationModelFromCompilationStatusAndChildren((IntentGenericElement)this.documentRoot, this.elementsToDocuments.values().iterator().next().iterator().next());
        }
    }

    private void handleContentHasChanged(EObject modifiedObject, Object modifiedObjectIdentifier) {
        if (modifiedObject instanceof IntentStructuredElement || modifiedObject instanceof UnitInstruction) {
            if (this.listenedElementsHandler.getRepositoryAdapter().getIDFromElement(this.documentRoot).equals(modifiedObjectIdentifier)) {
                this.documentRoot = modifiedObject;
            }
            for (IntentEditorDocument relatedDocument : this.elementsToDocuments.get(modifiedObjectIdentifier)) {
                relatedDocument.setAST(this.documentRoot);
                relatedDocument.reloadFromAST();
                this.addAllContentAsIntentElement(this.documentRoot, relatedDocument);
            }
            this.partitioner.computePartitioning(0, 1);
            this.refreshOutline(this.documentRoot);
        }
    }
}

