/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorDocument;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.AbstractIntentFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.IntentCompareConfiguration;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.compare.utils.EMFCompareUtils;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.StructuralFeatureChangeStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;
import org.eclipse.swt.widgets.Composite;

public class EMFCompareFix
extends AbstractIntentFix {
    private static final String COMPARE_EDITOR_TITLE = "Comparing Intent Document and Working Copy";
    private ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public EMFCompareFix(IntentAnnotation annotation) {
        super(annotation);
    }

    protected void applyFix(RepositoryAdapter repositoryAdapter, IntentEditorDocument document) {
        URI workingCopyElementURI = URI.createURI((String)((SynchronizerCompilationStatus)this.syncAnnotation.getCompilationStatus()).getWorkingCopyResourceURI().replace("\"", ""));
        String generatedResourcePath = ((SynchronizerCompilationStatus)this.syncAnnotation.getCompilationStatus()).getCompiledResourceURI().replace("\"", "");
        EObject generatedElement = (EObject)repositoryAdapter.getResource(generatedResourcePath).getContents().iterator().next();
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource workingCopyResource = rs.getResource(workingCopyElementURI.trimFragment(), true);
        EObject workingCopyElement = null;
        workingCopyElement = workingCopyElementURI.hasFragment() ? workingCopyResource.getEObject(workingCopyElementURI.fragment()) : (EObject)workingCopyResource.getContents().iterator().next();
        Comparison comparison = EMFCompareUtils.compare((Notifier)generatedElement, (Notifier)workingCopyElement);
        IntentCompareConfiguration compareConfig = new IntentCompareConfiguration(generatedElement, workingCopyElement);
        compareConfig.setProperty("org.eclipse.emf.compare.ide.ui.COMPARE.RESULT", comparison);
        compareConfig.setProperty("org.eclipse.emf.compare.ide.ui.EDITING_DOMAIN", EMFCompareEditingDomain.create((Notifier)generatedElement, (Notifier)workingCopyElement, null));
        IntentCompareEditorInput input = new IntentCompareEditorInput(compareConfig, comparison);
        compareConfig.setContainer((ICompareContainer)input);
        input.setTitle("Comparing Intent Document and Working Copy (" + workingCopyElementURI + ")");
        CompareUI.openCompareDialog((CompareEditorInput)input);
    }

    public String getDisplayString() {
        return "See differences in Compare Editor";
    }

    class IntentCompareEditorInput
    extends CompareEditorInput {
        private Object selection;

        public IntentCompareEditorInput(CompareConfiguration configuration, Comparison comparison) {
            EObject element;
            Match match;
            super(configuration);
            this.selection = comparison;
            CompilationStatus status = EMFCompareFix.this.syncAnnotation.getCompilationStatus();
            if (status instanceof StructuralFeatureChangeStatus && (match = comparison.getMatch(element = ((StructuralFeatureChangeStatus)status).getCompiledElement())) != null) {
                match.getDifferences().size();
            }
        }

        protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            return (IDiffElement)EMFCompareFix.this.adapterFactory.adapt(this.selection, IDiffElement.class);
        }

        public Viewer createDiffViewer(Composite parent) {
            return super.createDiffViewer(parent);
        }
    }
}

