/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.navigator;

import java.util.LinkedHashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.client.ui.ide.navigator.ProjectExplorerRefreshJob;
import org.eclipse.mylyn.docs.intent.client.ui.ide.navigator.UpdateProblemsViewJob;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.query.CompilationStatusQuery;
import org.eclipse.mylyn.docs.intent.collab.common.query.IndexQuery;
import org.eclipse.mylyn.docs.intent.collab.common.repository.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryObjectHandler;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.AbstractRepositoryClient;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.ReadWriteRepositoryObjectHandlerImpl;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.notification.elementList.ElementListNotificator;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.Notificator;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotification;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;

public class ProjectExplorerRefresher
extends AbstractRepositoryClient {
    private static final long UPDATE_PROBLEM_VIEW_JOB_DELAY = 200L;
    private IProject project;
    private Job updateProblemViewJob;

    public ProjectExplorerRefresher(IProject project, Repository repository) {
        super(repository);
        this.project = project;
        this.updateProblemView();
    }

    public static ProjectExplorerRefresher createProjectExplorerRefresher(IProject project) throws RepositoryConnectionException, CoreException, ReadOnlyException {
        Repository repository = IntentRepositoryManager.INSTANCE.getRepository(project.getName());
        RepositoryAdapter repositoryAdapter = repository.createRepositoryAdapter();
        repositoryAdapter.openSaveContext();
        ReadWriteRepositoryObjectHandlerImpl handler = new ReadWriteRepositoryObjectHandlerImpl(repositoryAdapter);
        LinkedHashSet<Object> listenedElements = new LinkedHashSet<Object>();
        listenedElements.add(new IndexQuery(repositoryAdapter).getOrCreateIntentIndex());
        listenedElements.add(new CompilationStatusQuery(repositoryAdapter).getOrCreateCompilationStatusManager());
        ElementListNotificator listenedElementsNotificator = new ElementListNotificator(listenedElements, repositoryAdapter);
        handler.addNotificator((Notificator)listenedElementsNotificator);
        ProjectExplorerRefresher refresher = new ProjectExplorerRefresher(project, repository);
        refresher.addRepositoryObjectHandler((RepositoryObjectHandler)handler);
        return refresher;
    }

    protected Job createNotificationJob(RepositoryChangeNotification notification) {
        ProjectExplorerRefreshJob res = null;
        res = notification != null && notification.getImpactedElements().isEmpty() ? new ProjectExplorerRefreshJob(this.project, (EObject)notification.getImpactedElements().iterator().next()) : new ProjectExplorerRefreshJob(this.project, null);
        this.updateProblemView();
        IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[ProjectExplorer Refresher] Project explorer and Problem view refreshed");
        return res;
    }

    private void updateProblemView() {
        if (this.updateProblemViewJob != null) {
            this.updateProblemViewJob.cancel();
        }
        if (this.getRepositoryObjectHandler() != null && this.getRepositoryObjectHandler().getRepositoryAdapter() != null) {
            this.updateProblemViewJob = new UpdateProblemsViewJob(this.project, this.getRepositoryObjectHandler().getRepositoryAdapter());
            this.updateProblemViewJob.schedule(200L);
        }
    }
}

