/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.exporter.ui.popup.actions;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.collab.common.query.IntentDocumentQuery;
import org.eclipse.mylyn.docs.intent.collab.common.repository.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexEntry;
import org.eclipse.mylyn.docs.intent.exporter.api.IntentHTMLExporter;
import org.eclipse.mylyn.docs.intent.exporter.ui.popup.actions.ExportOptionsDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportIntentDocumentationAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            IProject intentProject = null;
            IntentStructuredElement intentElement = null;
            try {
                ExportOptionsDialog exportOptionsDialog;
                if (((StructuredSelection)selection).getFirstElement() instanceof IProject) {
                    intentProject = (IProject)((StructuredSelection)selection).getFirstElement();
                    intentElement = new IntentDocumentQuery(IntentRepositoryManager.INSTANCE.getRepository(intentProject.getName()).createRepositoryAdapter()).getOrCreateIntentDocument();
                } else {
                    intentElement = null;
                    if (((StructuredSelection)selection).getFirstElement() instanceof IntentStructuredElement) {
                        intentElement = (IntentStructuredElement)((StructuredSelection)selection).getFirstElement();
                    }
                    if (((StructuredSelection)selection).getFirstElement() instanceof IntentIndexEntry) {
                        intentElement = (IntentStructuredElement)((IntentIndexEntry)((StructuredSelection)selection).getFirstElement()).getReferencedElement();
                    }
                    if (intentElement != null) {
                        String projectName = IntentRepositoryManager.INSTANCE.getRepository(EcoreUtil.getURI((EObject)((EObject)((StructuredSelection)selection).getFirstElement())).toString()).getIdentifier();
                        intentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    }
                }
                if (intentProject != null && (exportOptionsDialog = new ExportOptionsDialog(Display.getCurrent().getActiveShell(), String.valueOf(new File(intentProject.getLocationURI()).getAbsolutePath()) + "/generated", intentElement)).open() == 0) {
                    final IntentStructuredElement intentElementToExport = intentElement;
                    final IProject correspondingProject = intentProject;
                    Job exportJob = new Job("Exporting documentation as HTML"){

                        protected IStatus run(IProgressMonitor monitor) {
                            new IntentHTMLExporter().exportIntentDocumentation(intentElementToExport, exportOptionsDialog.getTargetFolderLocation(), exportOptionsDialog.getExportedIntentDocumentName(), BasicMonitor.toMonitor((IProgressMonitor)monitor));
                            File targetFolder = new File(exportOptionsDialog.getTargetFolderLocation());
                            String projectRelativePath = targetFolder.getAbsolutePath().toString().replace(new File(correspondingProject.getLocationURI()).getAbsolutePath().toString(), "").substring(1);
                            IFolder targetFolderInWorkspace = correspondingProject.getFolder((IPath)new Path(projectRelativePath));
                            try {
                                if (targetFolderInWorkspace.exists()) {
                                    targetFolderInWorkspace.refreshLocal(2, null);
                                } else {
                                    correspondingProject.refreshLocal(2, null);
                                }
                            }
                            catch (CoreException e) {
                                IntentUiLogger.logError((Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    exportJob.schedule();
                }
            }
            catch (RepositoryConnectionException e) {
                IntentUiLogger.logError((Throwable)e);
            }
            catch (CoreException e) {
                IntentUiLogger.logError((Throwable)e);
            }
        }
        return null;
    }
}

