/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.exporter;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.parser.compiler.AbstractAcceleoCompiler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionUnitPackage;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocumentPackage;
import org.eclipse.mylyn.docs.intent.core.genericunit.GenericUnitPackage;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitPackage;
import org.eclipse.mylyn.docs.intent.markup.markup.MarkupPackage;
import org.eclipse.mylyn.docs.intent.markup.wikigen.WikigenPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoCompiler
extends AbstractAcceleoCompiler {
    public static void main(String[] args) {
        if (args.length < 3) {
            throw new IllegalArgumentException("Missing parameters");
        }
        AcceleoCompiler acceleoCompiler = new AcceleoCompiler();
        acceleoCompiler.setSourceFolder(args[0]);
        acceleoCompiler.setOutputFolder(args[1]);
        acceleoCompiler.setBinaryResource(Boolean.valueOf(args[2]));
        if (args.length == 4 && args[3] != null && !"".equals(args[3])) {
            acceleoCompiler.setDependencies(args[3]);
        }
        acceleoCompiler.doCompile((Monitor)new BasicMonitor());
    }

    public void doCompile(Monitor monitor) {
        super.doCompile(monitor);
    }

    protected void registerPackages() {
        super.registerPackages();
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/intent/markup/0.7", (Object)MarkupPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/intent/markup/generator/0.7", (Object)WikigenPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/intent/intentdocument/0.7", (Object)IntentDocumentPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/intent/modelingunit/0.7", (Object)ModelingUnitPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/intent/genericunit/0.7", (Object)GenericUnitPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/intent/descriptionunit/0.7", (Object)DescriptionUnitPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
    }

    protected void registerResourceFactories() {
        super.registerResourceFactories();
    }

    protected void computeDependencies(List<URI> dependenciesURIs, Map<URI, URI> mapURIs) {
        Iterator identifiersIt = this.dependenciesIDs.iterator();
        Iterator dependenciesIt = this.dependencies.iterator();
        while (dependenciesIt.hasNext() && identifiersIt.hasNext()) {
            File requiredFolder = (File)dependenciesIt.next();
            String identifier = (String)identifiersIt.next();
            if (requiredFolder == null || !requiredFolder.exists() || !requiredFolder.isDirectory()) continue;
            ArrayList emtlFiles = new ArrayList();
            this.members(emtlFiles, requiredFolder, "emtl");
            for (File emtlFile : emtlFiles) {
                String requiredFolderAbsolutePath = requiredFolder.getAbsolutePath();
                if (requiredFolderAbsolutePath.endsWith("target/classes")) {
                    String[] splited = requiredFolderAbsolutePath.split("\\/");
                    StringBuffer buf = new StringBuffer(requiredFolderAbsolutePath.length());
                    int i = 0;
                    while (i < splited.length - 3) {
                        buf.append(splited[i]);
                        buf.append("/");
                        ++i;
                    }
                    requiredFolderAbsolutePath = buf.toString();
                    String emtlAbsolutePath = emtlFile.getAbsolutePath();
                    URI emtlFileURI = URI.createFileURI((String)emtlAbsolutePath);
                    dependenciesURIs.add(emtlFileURI);
                    String emtlModifiedPath = emtlAbsolutePath.replaceAll("target\\/|classes\\/", "");
                    Path relativePath = new Path(emtlModifiedPath.substring(requiredFolderAbsolutePath.length()));
                    URI relativeURI = URI.createPlatformPluginURI((String)relativePath.toString(), (boolean)false);
                    mapURIs.put(emtlFileURI, relativeURI);
                    continue;
                }
                String emtlAbsolutePath = emtlFile.getAbsolutePath();
                URI emtlFileURI = URI.createFileURI((String)emtlAbsolutePath);
                dependenciesURIs.add(emtlFileURI);
                IPath relativePath = new Path(identifier).append(emtlAbsolutePath.substring(requiredFolderAbsolutePath.length()));
                mapURIs.put(emtlFileURI, URI.createPlatformPluginURI((String)relativePath.toString(), (boolean)false));
            }
        }
    }
}

