/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentDocumentProvider;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorDocument;
import org.eclipse.mylyn.docs.intent.client.ui.utils.IntentEditorOpener;
import org.eclipse.mylyn.docs.intent.core.genericunit.IntentReferenceInstruction;
import org.eclipse.mylyn.docs.intent.serializer.ParsedElementPosition;
import org.eclipse.ui.texteditor.ITextEditor;

public class IntentHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IntentEditorDocument document;
        EObject element;
        EObject target;
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (!textEditor.isDirty() && region != null && textEditor instanceof IntentEditor && textEditor.getEditorInput() != null && (target = this.getTarget(element = (document = (IntentEditorDocument)((IntentDocumentProvider)textEditor.getDocumentProvider()).getDocument(textEditor.getEditorInput())).getElementAtOffset(region.getOffset()))) != null) {
            Region hyperlinkRegion = this.getHyperlinkRegion(document, element);
            return new IHyperlink[]{new IntentHyperlink((IntentEditor)textEditor, (IRegion)hyperlinkRegion, target)};
        }
        return null;
    }

    private Region getHyperlinkRegion(IntentEditorDocument document, EObject element) {
        ParsedElementPosition actualPosition = document.getIntentPosition(element);
        int offset = actualPosition.getOffset();
        int length = actualPosition.getLength();
        if (element instanceof IntentReferenceInstruction) {
            try {
                String text = document.get(offset, length);
                int refStart = text.indexOf("\"") + 1;
                offset += refStart;
                length = text.indexOf("\"", refStart) - refStart;
            }
            catch (BadLocationException badLocationException) {}
        }
        Region hyperlinkRegion = new Region(Math.max(0, offset), Math.max(0, length));
        return hyperlinkRegion;
    }

    private EObject getTarget(EObject element) {
        EObject target = null;
        if (element instanceof IntentReferenceInstruction) {
            IntentReferenceInstruction ref = (IntentReferenceInstruction)element;
            target = ref.getReferencedElement();
        }
        return target;
    }

    private class IntentHyperlink
    implements IHyperlink {
        private final IRegion hyperLinkRegion;
        private final EObject target;
        private final IntentEditor sourceEditor;

        public IntentHyperlink(IntentEditor editor, IRegion region, EObject linkTarget) {
            this.sourceEditor = editor;
            this.hyperLinkRegion = region;
            this.target = linkTarget;
        }

        public IRegion getHyperlinkRegion() {
            return this.hyperLinkRegion;
        }

        public String getHyperlinkText() {
            return "Open declaration for " + this.target;
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            if (this.target != null) {
                IntentEditorOpener.openIntentEditor(((IntentDocumentProvider)this.sourceEditor.getDocumentProvider()).getRepository(), this.target, false, this.target, false);
            }
        }
    }
}

