/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.bridge.ide.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.docs.intent.client.ui.editor.renderers.IEditorRendererExtension;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ResourceTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIDEEditorRendererExtension
implements IEditorRendererExtension {
    private static final int IMAGE_HEIGHT_MARGIN = 5;
    private static final int IMAGE_WIDTH = 800;

    public boolean isRendererFor(ExternalContentReference externalContentReference) {
        return true;
    }

    public boolean openEditor(ExternalContentReference externalContentReference) {
        URI resourceToOpenURI = URI.createURI((String)externalContentReference.getUri().toString().trim());
        if ("intent".equals(resourceToOpenURI.scheme()) && externalContentReference.getExternalContent() != null) {
            resourceToOpenURI = EcoreUtil.getURI((EObject)externalContentReference.getExternalContent()).trimFragment();
        }
        if (resourceToOpenURI.isPlatformResource()) {
            block21: {
                String filePath = resourceToOpenURI.trimFragment().toPlatformString(true);
                IFile resourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
                FileEditorInput editorInput = new FileEditorInput(resourceFile);
                if ("repomodel".equals(resourceToOpenURI.fileExtension())) {
                    resourceToOpenURI = resourceToOpenURI.trimFileExtension();
                }
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(resourceToOpenURI.trimFragment().lastSegment());
                IEditorPart openedEditor = null;
                if (desc != null) {
                    try {
                        openedEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, desc.getId());
                    }
                    catch (PartInitException e) {
                        IntentUiLogger.logError((Throwable)e);
                    }
                }
                if (openedEditor instanceof IGotoMarker && resourceToOpenURI.hasFragment()) {
                    IMarker shadowMarker = null;
                    try {
                        try {
                            shadowMarker = resourceFile.createMarker("org.eclipse.emf.validation.problem");
                            shadowMarker.setAttribute("uri", (Object)resourceToOpenURI.toString());
                            ((IGotoMarker)openedEditor).gotoMarker(shadowMarker);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            if (shadowMarker != null) {
                                try {
                                    shadowMarker.delete();
                                }
                                catch (CoreException coreException) {}
                            }
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        if (shadowMarker != null) {
                            try {
                                shadowMarker.delete();
                            }
                            catch (CoreException coreException) {}
                        }
                        throw throwable;
                    }
                    if (shadowMarker != null) {
                        try {
                            shadowMarker.delete();
                        }
                        catch (CoreException coreException) {}
                    }
                }
            }
            return true;
        }
        return false;
    }

    public Collection<Transfer> getAdditionalTransfers() {
        ArrayList<Transfer> transfers = new ArrayList<Transfer>();
        transfers.add((Transfer)ResourceTransfer.getInstance());
        transfers.add((Transfer)LocalSelectionTransfer.getTransfer());
        return transfers;
    }

    public Collection<? extends EObject> getEObjectsFromDropTargetEvent(DropTargetEvent event) {
        LinkedHashSet<EObject> eObjects = new LinkedHashSet<EObject>();
        try {
            LinkedHashSet<Resource> emfResources = new LinkedHashSet<Resource>();
            if (event.data instanceof IResource[]) {
                IResource[] droppedResources = (IResource[])event.data;
                int i = 0;
                while (i < droppedResources.length) {
                    emfResources.add(this.getEMFResourceFromIResource(droppedResources[i]));
                    ++i;
                }
            } else if (event.data instanceof IStructuredSelection) {
                for (Object element : (IStructuredSelection)event.data) {
                    if (!(element instanceof IResource)) continue;
                    emfResources.add(this.getEMFResourceFromIResource((IResource)element));
                }
            }
            for (Resource emfResource : emfResources) {
                if (emfResource == null || !emfResource.getContents().iterator().hasNext()) continue;
                eObjects.add((EObject)emfResource.getContents().iterator().next());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return eObjects;
    }

    private Resource getEMFResourceFromIResource(IResource iResource) {
        URI resourceURI = URI.createPlatformResourceURI((String)iResource.getFullPath().toString(), (boolean)true);
        try {
            return new ResourceSetImpl().getResource(resourceURI, true);
        }
        catch (Exception e) {
            IntentUiLogger.logError((String)("Could not perform drop of the resource at URI " + resourceURI + " because a bridge to represent such files as models is missing"), (Throwable)e);
            return null;
        }
    }

    public Image getImage(ExternalContentReference externalContentReference) {
        IItemLabelProvider labeProvider;
        Image image = null;
        if (externalContentReference.getExternalContent() != null && (labeProvider = (IItemLabelProvider)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE).adapt((Notifier)externalContentReference.getExternalContent(), IItemLabelProvider.class)) != null) {
            String label = labeProvider.getText((Object)externalContentReference.getExternalContent());
            Display display = Display.getDefault();
            int fontHeight = new GC((Drawable)new Image((Device)display, 1, 1)).getFontMetrics().getHeight();
            int imageHeight = fontHeight + 5;
            image = new Image((Device)display, 800, imageHeight);
            GC gc = new GC((Drawable)image);
            int iconWidth = 5;
            gc.setForeground(display.getSystemColor(16));
            Object iconURL = labeProvider.getImage((Object)externalContentReference.getExternalContent());
            Image icon = ExtendedImageRegistry.getInstance().getImage(iconURL);
            if (icon != null) {
                gc.drawImage(icon, 0, 5);
                iconWidth += icon.getImageData().width + 2;
            }
            gc.drawText(label, iconWidth, 5);
            gc.dispose();
        }
        return image;
    }
}

