/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.cdo.adapters;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ReadOnlyException;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.cdo.view.CDOInvalidationPolicy;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.mylyn.docs.intent.collab.cdo.adapters.CDOTypeListener;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryStructurer;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.SaveException;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.Notificator;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.net4j.util.event.IListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOAdapter
implements RepositoryAdapter {
    private static final CDOInvalidationPolicy INTENT_CDO_INVALIDATION_POLICY = new CDOInvalidationPolicy(){

        public void handleInvalidation(CDOObject object, CDORevisionKey key) {
            if (object instanceof InternalCDOObject) {
                ((InternalCDOObject)object).cdoInternalSetRevision(null);
            }
        }

        public void handleInvalidObject(CDOObject object) {
        }
    };
    private CDOSession session;
    private CDOView currentContext;
    private boolean isReadOnlyContext;
    private Map<Notificator, Set<IListener>> notificatorToListener = new HashMap<Notificator, Set<IListener>>();
    private boolean allowChangeSubscriptionPolicy = false;
    private Repository repository;

    public CDOAdapter(Repository repository, Object object) {
        this.repository = repository;
        this.setSession(object);
    }

    public void setSession(Object session) {
        if (!(session instanceof CDOSession)) {
            throw new IllegalArgumentException("The session associated to CDOAdapter must be a CDOSession");
        }
        this.session = (CDOSession)session;
    }

    public Object getSession() {
        return this.session;
    }

    public Object openSaveContext() {
        if (this.currentContext == null) {
            this.currentContext = this.session.openTransaction((ResourceSet)new ResourceSetImpl());
            this.currentContext.options().setInvalidationPolicy(INTENT_CDO_INVALIDATION_POLICY);
            this.setChangeSubscriptionPolicy();
            this.isReadOnlyContext = false;
        }
        return this.getContext();
    }

    private void setChangeSubscriptionPolicy() {
        if (this.allowChangeSubscriptionPolicy && this.currentContext != null) {
            this.currentContext.options().addChangeSubscriptionPolicy(CDOAdapterPolicy.ALL);
        }
    }

    public Object openReadOnlyContext() {
        this.isReadOnlyContext = true;
        if (this.currentContext == null) {
            this.currentContext = this.session.openView();
        }
        return null;
    }

    public void save() throws SaveException, ReadOnlyException {
        if (this.isReadOnlyContext) {
            throw new ReadOnlyException("Cannot save with a read-only context. The context should have been started with the 'openSaveContext' method.");
        }
        try {
            ((CDOTransaction)this.currentContext).commit();
        }
        catch (CommitException ce) {
            SaveException e = new SaveException(ce.getMessage());
            e.setStackTrace(ce.getStackTrace());
            throw e;
        }
        catch (ReadOnlyException roe) {
            SaveException e = new SaveException(roe.getMessage());
            e.setStackTrace(roe.getStackTrace());
            throw e;
        }
    }

    public void undo() throws ReadOnlyException {
        if (this.isReadOnlyContext) {
            throw new ReadOnlyException("Cannot undo action with a read-only context. The context should have been started with the 'openSaveContext' method.");
        }
        if (this.currentContext != null) {
            ((CDOTransaction)this.currentContext).rollback();
        }
    }

    public void closeContext() {
        if (this.currentContext != null) {
            this.currentContext.close();
            this.isReadOnlyContext = false;
        }
    }

    public void attachSessionListenerForTypes(Notificator typeNotificator, Set<EStructuralFeature> types) {
        this.session.options().setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode.ADDITIONS);
        CDOTypeListener typeListener = new CDOTypeListener(typeNotificator, types);
        if (this.notificatorToListener.get(typeNotificator) == null) {
            this.notificatorToListener.put(typeNotificator, new LinkedHashSet());
        }
        this.notificatorToListener.get(typeNotificator).add(typeListener);
        this.session.addListener((IListener)typeListener);
    }

    public void detachSessionListenerForTypes(Notificator typeNotificator) {
        for (IListener listenerToRemove : this.notificatorToListener.get(typeNotificator)) {
            this.session.removeListener(listenerToRemove);
        }
        this.notificatorToListener.remove(typeNotificator);
    }

    public Object getContext() {
        return this.currentContext;
    }

    public void allowChangeSubscriptionPolicy() {
        this.allowChangeSubscriptionPolicy = true;
        this.setChangeSubscriptionPolicy();
    }

    public Resource getResource(String path) {
        return this.currentContext.getResource(path);
    }

    public Resource getOrCreateResource(String path) {
        if (this.isReadOnlyContext) {
            throw new ReadOnlyException("Cannot create any resource with a read-only context. The context should have been started with the 'openSaveContext' method.");
        }
        if (this.currentContext != null) {
            return ((CDOTransaction)this.currentContext).getOrCreateResource(path);
        }
        return null;
    }

    public EObject getElementWithID(Object id) {
        if (id instanceof CDOID) {
            return this.currentContext.getObject((CDOID)id);
        }
        return null;
    }

    public Object getIDFromElement(EObject element) {
        if (element instanceof CDOObject) {
            return ((CDOObject)element).cdoID();
        }
        return null;
    }

    public void attachRepositoryStructurer(RepositoryStructurer structurer) {
        throw new UnsupportedOperationException("Can't define structurer on aCDO Repository.");
    }

    public void setSendSessionWarningBeforeSaving(boolean notifySessionBeforeSaving) {
    }

    public void setSendSessionWarningBeforeSaving(Collection<String> resourcesToIgnorePaths) {
    }

    public EObject reload(EObject elementToReload) {
        if (elementToReload instanceof CDOObject) {
            ((CDOObject)elementToReload).cdoReload();
            return elementToReload;
        }
        throw new IllegalArgumentException("Cannot reload an element which is not a CDOObject");
    }

    public String getResourcePath(URI resourceURI) {
        return CDOURIUtil.extractResourcePath((URI)resourceURI);
    }

    public void execute(IntentCommand command) {
        command.execute();
    }

    public Repository getRepository() {
        return this.repository;
    }

    public ResourceSet getResourceSet() {
        if (this.currentContext != null) {
            return this.currentContext.getResourceSet();
        }
        return null;
    }
}

