/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.serializer.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.ModelingUnitFormatter;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.serializer.ModelingUnitSerializer;
import org.eclipse.mylyn.docs.intent.serializer.IntentPositionManager;
import org.eclipse.mylyn.docs.intent.serializer.ParsedElementPosition;
import org.eclipse.mylyn.docs.intent.serializer.descriptionunit.DescriptionUnitSerializer;
import org.eclipse.mylyn.docs.intent.serializer.internal.IntentDocumentSerializeSwitch;

public class IntentElementSerializer {
    private IntentDocumentSerializeSwitch serializerSwitch;
    private ModelingUnitSerializer modelingUnitSerializer;
    private DescriptionUnitSerializer descriptionUnitSerializer;
    private int currentOffset;
    private int currentIndentationLevel;
    private IntentPositionManager positionManager = new IntentPositionManager();
    private String modelingUnitPrefixDecoration;
    private String modelingUnitSuffixDecoration;

    public IntentElementSerializer(String modelingUnitPrefixDecoration, String modelingUnitSuffixDecoration) {
        this.serializerSwitch = new IntentDocumentSerializeSwitch(this);
        this.modelingUnitSerializer = new ModelingUnitSerializer();
        this.descriptionUnitSerializer = new DescriptionUnitSerializer();
        this.modelingUnitPrefixDecoration = modelingUnitPrefixDecoration;
        this.modelingUnitSuffixDecoration = modelingUnitSuffixDecoration;
    }

    public void clear() {
        this.positionManager.clear();
        this.setCurrentOffset(0);
        this.setCurrentIndendationLevel(0);
    }

    public String serialize(EObject content) {
        String serializedFrom = "";
        if (content instanceof ModelingUnit) {
            serializedFrom = this.handleModelingUnitSerialization(content);
        }
        if (content instanceof DescriptionUnit) {
            serializedFrom = this.handleDescriptionUnitSerialization(content);
        }
        if (content instanceof IntentStructuredElement) {
            serializedFrom = (String)this.serializerSwitch.doSwitch(content);
        }
        return serializedFrom;
    }

    private String handleDescriptionUnitSerialization(EObject descriptionUnit) {
        String serializedDescriptionUnit = this.descriptionUnitSerializer.serialize((DescriptionUnit)descriptionUnit, this.tabulation(), this.getCurrentOffset());
        this.setCurrentOffset(this.getCurrentOffset() + serializedDescriptionUnit.length());
        this.positionManager.addIntentPositionManagerInformations(this.descriptionUnitSerializer.getPositionManager());
        return serializedDescriptionUnit;
    }

    private String handleModelingUnitSerialization(EObject modelingUnit) {
        int initialOffset = this.getCurrentOffset();
        int length = 0;
        int prefixLength = 0;
        String serializedModelingUnit = "";
        if (this.modelingUnitPrefixDecoration != null) {
            serializedModelingUnit = String.valueOf(serializedModelingUnit) + this.modelingUnitPrefixDecoration;
            this.setCurrentOffset(initialOffset + this.modelingUnitPrefixDecoration.length());
            prefixLength = serializedModelingUnit.length();
        }
        serializedModelingUnit = String.valueOf(serializedModelingUnit) + this.modelingUnitSerializer.serialize((ModelingUnit)modelingUnit, this.getCurrentOffset());
        String serializedModelingUnitFormatted = ModelingUnitFormatter.indentAccordingToBrackets(this.modelingUnitSerializer, serializedModelingUnit, this.getCurrentIndendationLevel(), initialOffset);
        length = serializedModelingUnitFormatted.length() - prefixLength - this.getCurrentIndendationLevel() * 2;
        ParsedElementPosition pos = this.modelingUnitSerializer.getPositionManager().getPositionForElement(modelingUnit);
        this.modelingUnitSerializer.getPositionManager().setPositionForInstruction(modelingUnit, pos.getOffset(), length);
        if (this.modelingUnitSuffixDecoration != null) {
            serializedModelingUnitFormatted = String.valueOf(serializedModelingUnitFormatted) + this.tabulation() + this.modelingUnitSuffixDecoration;
        }
        this.setCurrentOffset(initialOffset + serializedModelingUnitFormatted.length());
        this.positionManager.addIntentPositionManagerInformations(this.modelingUnitSerializer.getPositionManager());
        return serializedModelingUnitFormatted;
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }

    public void setCurrentOffset(int offset) {
        this.currentOffset = offset;
    }

    public int getCurrentIndendationLevel() {
        return this.currentIndentationLevel;
    }

    public void setCurrentIndendationLevel(int indentationLevel) {
        this.currentIndentationLevel = indentationLevel;
    }

    public String tabulation() {
        String lineJump = "";
        int i = 0;
        while (i < this.getCurrentIndendationLevel()) {
            lineJump = String.valueOf(lineJump) + "\t";
            ++i;
        }
        return lineJump;
    }

    public void setPositionForElement(EObject element, int offset, int length, int declarationLength) {
        this.positionManager.setPositionForInstruction(element, offset, length, declarationLength);
    }

    public IntentPositionManager getPositionManager() {
        return this.positionManager;
    }
}

