/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler.utils;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.CompilationErrorType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusSeverity;

public final class CompilationStatusConverter {
    private CompilationStatusConverter() {
    }

    public static CompilationStatusSeverity createStatusSeverityFromDiagnosticSeverity(Diagnostic diagnostic) {
        CompilationStatusSeverity returnedSeverity = null;
        switch (diagnostic.getSeverity()) {
            case 1: {
                returnedSeverity = CompilationStatusSeverity.INFO;
                break;
            }
            case 4: {
                returnedSeverity = CompilationStatusSeverity.WARNING;
                break;
            }
            case 2: {
                returnedSeverity = CompilationStatusSeverity.WARNING;
                break;
            }
            default: {
                returnedSeverity = CompilationStatusSeverity.OK;
            }
        }
        return returnedSeverity;
    }

    public static CompilationMessageType createStatusTypeFromCompilationExceptionErrorType(CompilationErrorType type) {
        CompilationMessageType returnedMessageType = null;
        switch (type) {
            case INVALID_REFRENCE_ERROR: {
                returnedMessageType = CompilationMessageType.INVALID_REFERENCE_ERROR;
                break;
            }
            case INVALID_VALUE_ERROR: {
                returnedMessageType = CompilationMessageType.INVALID_VALUE_ERROR;
                break;
            }
            case PACKAGE_NOT_FOUND_ERROR: {
                returnedMessageType = CompilationMessageType.PACKAGE_NOT_FOUND_ERROR;
                break;
            }
            case PACKAGE_REGISTRATION_ERROR: {
                returnedMessageType = CompilationMessageType.PACKAGE_REGISTRATION_ERROR;
                break;
            }
            case RESOLVE_ERROR: {
                returnedMessageType = CompilationMessageType.RESOLVE_ERROR;
                break;
            }
            case VALIDATION_ERROR: {
                returnedMessageType = CompilationMessageType.VALIDATION_ERROR;
                break;
            }
            default: {
                returnedMessageType = CompilationMessageType.GENERAL_WARNING;
            }
        }
        return returnedMessageType;
    }

    public static CompilationStatusSeverity createStatusSeverityFromCompilationExceptionErrorType(CompilationErrorType type) {
        CompilationStatusSeverity returnedSeverity = null;
        switch (type) {
            case INVALID_REFRENCE_ERROR: {
                returnedSeverity = CompilationStatusSeverity.ERROR;
                break;
            }
            case INVALID_VALUE_ERROR: {
                returnedSeverity = CompilationStatusSeverity.ERROR;
                break;
            }
            case PACKAGE_NOT_FOUND_ERROR: {
                returnedSeverity = CompilationStatusSeverity.ERROR;
                break;
            }
            case PACKAGE_REGISTRATION_ERROR: {
                returnedSeverity = CompilationStatusSeverity.ERROR;
                break;
            }
            case RESOLVE_ERROR: {
                returnedSeverity = CompilationStatusSeverity.ERROR;
                break;
            }
            case VALIDATION_ERROR: {
                returnedSeverity = CompilationStatusSeverity.WARNING;
                break;
            }
            default: {
                returnedSeverity = CompilationStatusSeverity.INFO;
            }
        }
        return returnedSeverity;
    }
}

