/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.ide.repository;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceRepositoryLoader {
    private WorkspaceRepository workspaceRepository;
    private List<String> indexPathList;

    public WorkspaceRepositoryLoader(WorkspaceRepository workspaceRepository, List<String> indexPathList) {
        this.workspaceRepository = workspaceRepository;
        this.indexPathList = indexPathList;
    }

    public void loadResourceSet() {
        for (String indexPath : this.indexPathList) {
            this.addIndexFileToResourceSet(indexPath);
        }
    }

    private void addIndexFileToResourceSet(String indexRelativePath) {
        URI fileURI = this.workspaceRepository.getURIMatchingPath(indexRelativePath);
        try {
            if (this.workspaceRepository.getResourceSet().getURIConverter() != null) {
                this.workspaceRepository.getResourceSet().getResource(fileURI, true);
            }
        }
        catch (WrappedException wrappedException) {
            try {
                this.workspaceRepository.getResourceSet().createResource(fileURI).save(null);
            }
            catch (IOException iOException) {}
        }
    }
}

