/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.serializer;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.ModelingUnitFormatter;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.serializer.ModelingUnitSerializer;
import org.eclipse.mylyn.docs.intent.serializer.IntentPositionManager;
import org.eclipse.mylyn.docs.intent.serializer.descriptionunit.DescriptionUnitSerializer;
import org.eclipse.mylyn.docs.intent.serializer.internal.IntentElementSerializer;

public class IntentSerializer {
    private IntentPositionManager positionManager;
    private IntentElementSerializer documentSerializer;
    private ModelingUnitSerializer modelingUnitSerializer;
    private DescriptionUnitSerializer descriptionUnitSerializer;

    public IntentSerializer() {
        this.documentSerializer = new IntentElementSerializer(null, null);
        this.modelingUnitSerializer = new ModelingUnitSerializer();
        this.descriptionUnitSerializer = new DescriptionUnitSerializer();
        this.positionManager = new IntentPositionManager();
    }

    public IntentSerializer(String modelingUnitPrefixDecoration, String modelingUnitSuffixDecoration) {
        this.documentSerializer = new IntentElementSerializer(modelingUnitPrefixDecoration, modelingUnitSuffixDecoration);
        this.modelingUnitSerializer = new ModelingUnitSerializer();
        this.descriptionUnitSerializer = new DescriptionUnitSerializer();
        this.positionManager = new IntentPositionManager();
    }

    private void clear() {
        this.positionManager.clear();
        this.documentSerializer.clear();
        this.descriptionUnitSerializer.clear();
    }

    public synchronized String serialize(EObject elementToSerialize) {
        this.clear();
        if (elementToSerialize == null) {
            throw new IllegalArgumentException("Cannot serialize a null element.");
        }
        String serializedForm = null;
        if (elementToSerialize instanceof ModelingUnit) {
            serializedForm = this.modelingUnitSerializer.serialize((ModelingUnit)elementToSerialize);
            serializedForm = ModelingUnitFormatter.indentAccordingToBrackets(this.modelingUnitSerializer, serializedForm);
            this.positionManager.addIntentPositionManagerInformations(this.modelingUnitSerializer.getPositionManager());
        }
        if (elementToSerialize instanceof IntentStructuredElement) {
            this.documentSerializer.setCurrentOffset(0);
            this.documentSerializer.setCurrentIndendationLevel(0);
            serializedForm = this.documentSerializer.serialize(elementToSerialize);
            this.positionManager.addIntentPositionManagerInformations(this.documentSerializer.getPositionManager());
        }
        if (elementToSerialize instanceof DescriptionUnit) {
            this.documentSerializer.setCurrentOffset(0);
            this.documentSerializer.setCurrentIndendationLevel(0);
            serializedForm = this.descriptionUnitSerializer.serialize((DescriptionUnit)elementToSerialize);
            this.positionManager.addIntentPositionManagerInformations(this.descriptionUnitSerializer.getPositionManager());
        }
        if (serializedForm == null) {
            throw new IllegalArgumentException("The element to serialize must be a valid Intent element, and not " + elementToSerialize.eClass().getName());
        }
        return serializedForm;
    }

    public synchronized IntentPositionManager getPositionManager() {
        return this.positionManager;
    }
}

