/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.indexer;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.client.indexer.tocmaker.TocMaker;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.SaveException;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.AbstractRepositoryClient;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotification;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndex;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexerFactory;

public class IndexerRepositoryClient
extends AbstractRepositoryClient {
    private TocMaker indexComputor = new TocMaker();

    public IndexerRepositoryClient() {
        IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[Indexer] Ready");
    }

    public void makeToc() {
        final RepositoryAdapter repositoryAdapter = this.repositoryObjectHandler.getRepositoryAdapter();
        if (repositoryAdapter != null) {
            repositoryAdapter.execute(new IntentCommand(){

                public void execute() {
                    IntentIndex index = IndexerRepositoryClient.this.getIntentIndex();
                    IntentDocument document = IndexerRepositoryClient.this.getIntentDocument();
                    IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[Indexer] Indexing " + document.getChapters().size() + "chapters");
                    repositoryAdapter.openSaveContext();
                    IndexerRepositoryClient.this.indexComputor.computeIndex(index, document);
                    try {
                        repositoryAdapter.save();
                    }
                    catch (SaveException e) {
                        IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "Indexer failed to save changes", (Throwable)e);
                    }
                    catch (ReadOnlyException e) {
                        IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "Indexer failed to save changes", (Throwable)e);
                    }
                    repositoryAdapter.closeContext();
                    IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[Indexer] Index saved");
                }
            });
        }
    }

    private IntentIndex getIntentIndex() {
        try {
            Resource indexResource = this.repositoryObjectHandler.getRepositoryAdapter().getOrCreateResource("/IntentIndex");
            if (indexResource.getContents().isEmpty()) {
                indexResource.getContents().add((Object)IntentIndexerFactory.eINSTANCE.createIntentIndex());
            }
            return (IntentIndex)indexResource.getContents().get(0);
        }
        catch (ReadOnlyException readOnlyException) {
            return null;
        }
    }

    private IntentDocument getIntentDocument() {
        Resource indexResource = this.repositoryObjectHandler.getRepositoryAdapter().getResource("/INTENT/IntentDocument");
        if (indexResource.getContents().size() > 0 && indexResource.getContents().get(0) instanceof IntentDocument) {
            return (IntentDocument)indexResource.getContents().get(0);
        }
        return null;
    }

    protected Job createNotificationJob(RepositoryChangeNotification notification) {
        Job job = new Job("Indexing"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus res = Status.OK_STATUS;
                IndexerRepositoryClient.this.makeToc();
                return res;
            }
        };
        job.setSystem(true);
        return job;
    }
}

