/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.serializer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.docs.intent.markup.markup.Entity;

public final class EntitySerializer {
    private static String COPYRIGHT_CODE = "#169";
    private static String COPYRIGHT_TRADUCTION = "(c)";
    private static String TRADEMARK_CODE = "#8482";
    private static String TRADEMARK_TRADUCTION = "(tm)";
    private static String REGISTERED_CODE = "#174";
    private static String REGISTERED_TRADUCTION = "(r)";
    private static String DASH_CODE = "#8211";
    private static String DASH_TRADUCTION = "-";
    private static String SIMPLEQUOTE_CODE = "#8217";
    private static String SIMPLEQUOTE2_CODE = "#8249";
    private static String SIMPLEQUOTE3_CODE = "#8250";
    private static String SIMPLEQUOTE4_CODE = "#8216";
    private static String SIMPLEQUOTE_TRADUCTION = "'";
    private static String LEFTDOUBLEQUOTE_CODE = "#171";
    private static String LEFTDOUBLEQUOTE1_CODE = "#8220";
    private static String LEFTDOUBLEQUOTE_TRADUCTION = "\"";
    private static String RIGHTDOUBLEQUOTE_CODE = "#187";
    private static String RIGHTDOUBLEQUOTE1_CODE = "#8221";
    private static String RIGHTDOUBLEQUOTE_TRADUCTION = "\"";
    private static String TABULATION_SYMBOL = "<dd/>";
    private static String TABULATION_TRADUCTION = "<dd/>";
    private static Map<String, String> entityMapping;

    private EntitySerializer() {
    }

    public static String render(Entity entity) {
        EntitySerializer.initializeEntityMapping();
        if (entityMapping.containsKey(entity.getData())) {
            return entityMapping.get(entity.getData());
        }
        return entity.getData();
    }

    private static void initializeEntityMapping() {
        if (entityMapping == null) {
            entityMapping = new HashMap<String, String>();
            entityMapping.put(COPYRIGHT_CODE, COPYRIGHT_TRADUCTION);
            entityMapping.put(TRADEMARK_CODE, TRADEMARK_TRADUCTION);
            entityMapping.put(REGISTERED_CODE, REGISTERED_TRADUCTION);
            entityMapping.put(DASH_CODE, DASH_TRADUCTION);
            entityMapping.put(SIMPLEQUOTE_CODE, SIMPLEQUOTE_TRADUCTION);
            entityMapping.put(SIMPLEQUOTE2_CODE, SIMPLEQUOTE_TRADUCTION);
            entityMapping.put(SIMPLEQUOTE3_CODE, SIMPLEQUOTE_TRADUCTION);
            entityMapping.put(SIMPLEQUOTE4_CODE, SIMPLEQUOTE_TRADUCTION);
            entityMapping.put(LEFTDOUBLEQUOTE_CODE, LEFTDOUBLEQUOTE_TRADUCTION);
            entityMapping.put(LEFTDOUBLEQUOTE1_CODE, LEFTDOUBLEQUOTE_TRADUCTION);
            entityMapping.put(RIGHTDOUBLEQUOTE_CODE, RIGHTDOUBLEQUOTE_TRADUCTION);
            entityMapping.put(RIGHTDOUBLEQUOTE1_CODE, RIGHTDOUBLEQUOTE_TRADUCTION);
            entityMapping.put(TABULATION_SYMBOL, TABULATION_TRADUCTION);
        }
    }
}

