/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.builder.operation;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.mylyn.docs.intent.markup.markup.Document;
import org.eclipse.mylyn.docs.intent.markup.markup.HasAttributes;
import org.eclipse.mylyn.docs.intent.markup.markup.Link;

public class DocumentLinkResolver {
    private Document doc;

    public DocumentLinkResolver(Document doc) {
        this.doc = doc;
    }

    public void resolveLinks() {
        HashMap idsToElements = Maps.newHashMap();
        UnmodifiableIterator it = Iterators.filter((Iterator)this.doc.eAllContents(), HasAttributes.class);
        while (it.hasNext()) {
            HasAttributes cur = (HasAttributes)it.next();
            if (cur.getAttributes() == null || cur.getAttributes().getId() == null) continue;
            idsToElements.put(cur.getAttributes().getId(), cur);
        }
        UnmodifiableIterator it2 = Iterators.filter((Iterator)this.doc.eAllContents(), Link.class);
        while (it2.hasNext()) {
            Link lnk = (Link)it2.next();
            HasAttributes target = (HasAttributes)idsToElements.get(lnk.getHrefOrHashName().substring(1));
            if (target == null) continue;
            lnk.setTarget(target);
        }
    }
}

