/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.synchronizer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.client.synchronizer.SynchronizeRepositoryJob;
import org.eclipse.mylyn.docs.intent.client.synchronizer.listeners.GeneratedElementListener;
import org.eclipse.mylyn.docs.intent.client.synchronizer.synchronizer.IntentSynchronizer;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.AbstractRepositoryClient;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotification;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusManager;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizerRepositoryClient
extends AbstractRepositoryClient {
    private IntentSynchronizer synchronizer;
    private TraceabilityIndex traceabilityIndex;

    public SynchronizerRepositoryClient(TraceabilityIndex traceabilityIndex) {
        System.out.println("[Synchronizer] Initialised.");
        this.synchronizer = new IntentSynchronizer(this);
        this.traceabilityIndex = traceabilityIndex;
    }

    public void addAllStatusToTargetElement(Collection<? extends CompilationStatus> statusList) {
        CompilationStatusManager statusManager = this.getStatusManager();
        Iterator iterator2 = Iterables.filter((Iterable)statusManager.getCompilationStatusList(), SynchronizerCompilationStatus.class).iterator();
        LinkedHashSet toRemove = Sets.newLinkedHashSet();
        while (iterator2.hasNext()) {
            SynchronizerCompilationStatus synchronizerCompilationStatus = (SynchronizerCompilationStatus)iterator2.next();
            synchronizerCompilationStatus.getTarget().getCompilationStatus().remove((Object)synchronizerCompilationStatus);
            statusManager.getModelingUnitToStatusList().remove((Object)synchronizerCompilationStatus);
            toRemove.add(synchronizerCompilationStatus);
        }
        statusManager.getCompilationStatusList().removeAll((Collection)toRemove);
        for (CompilationStatus compilationStatus : statusList) {
            compilationStatus.getTarget().getCompilationStatus().add((Object)compilationStatus);
            statusManager.getCompilationStatusList().add((Object)compilationStatus);
        }
    }

    private CompilationStatusManager getStatusManager() {
        Resource resource = this.repositoryObjectHandler.getRepositoryAdapter().getResource("/COMPILATION/STATUS/StatusIndex");
        CompilationStatusManager statusManager = null;
        if (resource != null && !resource.getContents().isEmpty()) {
            statusManager = (CompilationStatusManager)resource.getContents().iterator().next();
        }
        return statusManager;
    }

    public void setGeneratedElementListener(GeneratedElementListener generatedElementListener) {
        this.synchronizer.setGeneratedElementListener(generatedElementListener);
        generatedElementListener.setSynchronizer(this);
    }

    public TraceabilityIndex getTraceabilityIndex() {
        return this.traceabilityIndex;
    }

    public void setTraceabilityIndex(TraceabilityIndex traceabilityIndex) {
        this.traceabilityIndex = traceabilityIndex;
    }

    IntentSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    protected Job createNotificationJob(RepositoryChangeNotification notification) {
        return new SynchronizeRepositoryJob(this);
    }

    public void dispose() {
        this.synchronizer.dispose();
        super.dispose();
    }
}

