/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.parser.internal;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.parser.IntentParserUtil;
import org.eclipse.mylyn.docs.intent.parser.internal.IntentBuilder;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.ParseException;
import org.eclipse.mylyn.docs.intent.serializer.IntentPositionManager;

public class IntentDocumentParser {
    private IntentPositionManager positionManager = new IntentPositionManager();
    private IntentBuilder builder;

    public boolean isParserFor(String contentToParse) {
        String[] validFirstKeyWords = this.getValidFirstKeyWords();
        int validFirstKeyWordIndice = 0;
        boolean isValidContent = false;
        while (validFirstKeyWordIndice < validFirstKeyWords.length && !isValidContent) {
            isValidContent = contentToParse.startsWith(validFirstKeyWords[validFirstKeyWordIndice]);
            ++validFirstKeyWordIndice;
        }
        return isValidContent;
    }

    public EObject parse(String contentToParse) throws ParseException {
        this.builder = new IntentBuilder(this.positionManager);
        String remainingContentToParse = contentToParse;
        String currentlyParsedSentence = null;
        int cursor = 0;
        int offset = 0;
        while (remainingContentToParse.length() > 0 && cursor != -1) {
            cursor = IntentParserUtil.getNextOffset(remainingContentToParse);
            if (cursor == -1) continue;
            currentlyParsedSentence = remainingContentToParse.substring(0, cursor);
            this.sendSignal(offset += cursor, currentlyParsedSentence.trim());
            if (currentlyParsedSentence.contains("@M")) {
                int beginModelingUnit = remainingContentToParse.indexOf("@M");
                int endModelingUnit = remainingContentToParse.indexOf("M@");
                if (cursor < 0 || endModelingUnit < 0) {
                    throw new ParseException("Unclosed Modeling Unit", cursor, "M@".length());
                }
                String modelingUnitContent = remainingContentToParse.substring(beginModelingUnit, endModelingUnit += "M@".length());
                this.builder.modelingUnitContent(offset + beginModelingUnit - cursor, modelingUnitContent);
                offset += endModelingUnit - cursor;
                remainingContentToParse = remainingContentToParse.substring(endModelingUnit);
                continue;
            }
            remainingContentToParse = remainingContentToParse.substring(cursor);
        }
        return this.builder.getRoot();
    }

    private void sendSignal(int offset, String parsedSentence) throws ParseException {
        String parsedSentenceWithoutDescriptionUnit = this.sendDescriptionUnitSignalIfNecessary(offset, parsedSentence);
        if (parsedSentenceWithoutDescriptionUnit.contains("}")) {
            this.builder.endStructuredElement(offset);
        }
        if (parsedSentenceWithoutDescriptionUnit.contains("Document")) {
            this.builder.beginDocument(offset - parsedSentence.length(), parsedSentence.trim().length());
        }
        if (parsedSentenceWithoutDescriptionUnit.contains("Chapter")) {
            this.builder.beginChapter(offset - parsedSentence.length(), parsedSentence.trim().length());
        }
        if (parsedSentenceWithoutDescriptionUnit.contains("Section")) {
            this.sendBeginSectionSignal(offset - parsedSentenceWithoutDescriptionUnit.trim().length(), parsedSentenceWithoutDescriptionUnit);
        }
    }

    private String sendDescriptionUnitSignalIfNecessary(int offset, String parsedSentence) throws ParseException {
        String descriptionUnitContent = parsedSentence;
        String parsedSentenceWithoutDescriptionUnit = parsedSentence;
        String[] stringArray = IntentParserUtil.getEndingDescriptionUnitTokens();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String endingDescriptionUnitKeyword = stringArray[n2];
            Pattern ptr = Pattern.compile(endingDescriptionUnitKeyword);
            Matcher matcher = ptr.matcher(descriptionUnitContent);
            if (matcher.find()) {
                descriptionUnitContent = descriptionUnitContent.substring(0, matcher.start()).trim();
            }
            ++n2;
        }
        if (descriptionUnitContent.trim().length() > 0) {
            parsedSentenceWithoutDescriptionUnit = parsedSentenceWithoutDescriptionUnit.replace(descriptionUnitContent, "");
            this.builder.descriptionUnitContent(offset - parsedSentence.length(), descriptionUnitContent);
        }
        return parsedSentenceWithoutDescriptionUnit;
    }

    private void sendBeginSectionSignal(int offset, String parsedSentence) {
        String parsedSentenceCopy = parsedSentence;
        String visibility = null;
        ArrayList<String> headerReferences = new ArrayList<String>();
        if ((parsedSentenceCopy = parsedSentenceCopy.replace("Section", "").trim()).contains("[")) {
            parsedSentenceCopy = parsedSentenceCopy.replace("[", "").replace("]", "").replace("{", "");
            String[] headersTable = parsedSentenceCopy.split(",");
            int i = 0;
            while (i < headersTable.length) {
                headerReferences.add(headersTable[i].trim());
                ++i;
            }
        }
        this.builder.beginSection(offset, parsedSentence.trim().length());
        this.builder.sectionOptions(visibility, headerReferences);
    }

    private String[] getValidFirstKeyWords() {
        String[] validKeyWords = new String[]{"Chapter", "internal Chapter", "hidden Chapter", "Section", "hidden Section", "internal Section", "Document"};
        return validKeyWords;
    }

    public void clear() {
        this.positionManager.clear();
    }

    public IntentPositionManager getPositionManager() {
        return this.positionManager;
    }
}

