/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.scanner;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.ColorManager;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.IntentColorConstants;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.IntentFontConstants;
import org.eclipse.mylyn.docs.intent.client.ui.editor.scanner.AbstractIntentScanner;
import org.eclipse.mylyn.docs.intent.client.ui.editor.scanner.IntentWordDetector;
import org.eclipse.swt.graphics.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentStructuredElementScanner
extends AbstractIntentScanner {
    public static final String CLOSING = "";
    private static String[] STRUCTURED_KEYWORDS = new String[]{"Chapter", "Document", "Section", "hidden", "internal"};
    protected ColorManager colorManager;

    public IntentStructuredElementScanner(ColorManager colorManager) {
        this.colorManager = colorManager;
        Color backgroundColor = null;
        Color defaultforeGroundColor = colorManager.getColor(IntentColorConstants.DU_DEFAULT_FOREGROUND);
        Token defaultToken = new Token((Object)new TextAttribute(defaultforeGroundColor, backgroundColor, 0, IntentFontConstants.getDescriptionFont()));
        Color keyWordForeGroundColor = colorManager.getColor(IntentColorConstants.DU_KEYWORD_FOREGROUND);
        Token keyWordToken = new Token((Object)new TextAttribute(keyWordForeGroundColor, backgroundColor, 1));
        Color stringforeGroundColor = colorManager.getColor(IntentColorConstants.MU_STRING_FOREGROUND);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(this.computeKeyWordRule((IToken)defaultToken, (IToken)keyWordToken));
        rules.addAll(this.computeStringRules(stringforeGroundColor));
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    private IRule computeKeyWordRule(IToken defaultToken, IToken keyWordToken) {
        WordRule keyWordsRule = new WordRule((IWordDetector)new IntentWordDetector(), defaultToken);
        int i = 0;
        while (i < STRUCTURED_KEYWORDS.length) {
            keyWordsRule.addWord(STRUCTURED_KEYWORDS[i], keyWordToken);
            ++i;
        }
        return keyWordsRule;
    }

    private Collection<? extends IRule> computeStringRules(Color stringforeGroundColor) {
        Token stringToken = new Token((Object)new TextAttribute(stringforeGroundColor, null, 2));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new SingleLineRule("\"", "\"", (IToken)stringToken, '\\'));
        rules.add(new MultiLineRule("'", "'", (IToken)stringToken, '\\'));
        return rules;
    }

    @Override
    public String getConfiguredContentType() {
        return "__Intent__structuralcontent";
    }
}

