/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

public final class TriTuple<A, B, C> {
    private final A one;
    private final B two;
    private final C three;
    private String stringRep;

    private TriTuple(A one, B two, C three) {
        if (one == null && two == null && three == null) {
            throw new IllegalArgumentException("at least one argument must be non-null");
        }
        this.one = one;
        this.two = two;
        this.three = three;
    }

    public static <A, B, C> TriTuple<A, B, C> of(A one, B two, C three) {
        return new TriTuple<A, B, C>(one, two, three);
    }

    public A one() {
        return this.one;
    }

    public B two() {
        return this.two;
    }

    public C three() {
        return this.three;
    }

    public String toString() {
        if (this.stringRep == null) {
            this.stringRep = String.format("TriTuple[one: %s, two: %s, three: %s]", this.one, this.two, this.three);
        }
        return this.stringRep;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.one == null ? 0 : this.one.hashCode());
        result = 31 * result + (this.three == null ? 0 : this.three.hashCode());
        result = 31 * result + (this.two == null ? 0 : this.two.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TriTuple other = (TriTuple)obj;
        if (this.one == null ? other.one != null : !this.one.equals(other.one)) {
            return false;
        }
        if (this.three == null ? other.three != null : !this.three.equals(other.three)) {
            return false;
        }
        return !(this.two == null ? other.two != null : !this.two.equals(other.two));
    }
}

