/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import org.eclipse.hono.util.JsonHelper;

@JsonDeserialize
abstract class JsonBackedValueObject {
    @JsonIgnore
    protected final JsonObject json = new JsonObject();

    JsonBackedValueObject() {
    }

    @JsonAnyGetter
    private Map<String, Object> getPropertiesAsMap() {
        return this.json.getMap();
    }

    public final <T> T getProperty(String name, Class<T> clazz) {
        return JsonBackedValueObject.getProperty(this.json, name, clazz);
    }

    public final <T> T getProperty(String name, Class<T> clazz, T defaultValue) {
        return JsonBackedValueObject.getProperty(this.json, name, clazz, defaultValue);
    }

    protected static final <T> T getProperty(JsonObject parent, String name, Class<T> clazz) {
        return JsonBackedValueObject.getProperty(parent, name, clazz, null);
    }

    protected static final <T> T getProperty(JsonObject parent, String name, Class<T> clazz, T defaultValue) {
        return JsonHelper.getValue(parent, name, clazz, defaultValue);
    }
}

