/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import org.eclipse.hono.annotation.HonoTimestamp;
import org.eclipse.hono.util.LimitedResource;
import org.eclipse.hono.util.ResourceLimitsPeriod;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class DataVolume
extends LimitedResource {
    private final long maxBytes;

    public DataVolume(@JsonProperty(value="effective-since", required=true) @HonoTimestamp Instant effectiveSince, @JsonProperty(value="period") ResourceLimitsPeriod period) {
        this(effectiveSince, period, -1L);
    }

    @JsonCreator
    public DataVolume(@JsonProperty(value="effective-since", required=true) @HonoTimestamp Instant effectiveSince, @JsonProperty(value="period") ResourceLimitsPeriod period, @JsonProperty(value="max-bytes") long maxBytes) {
        super(effectiveSince, period);
        if (maxBytes < -1L) {
            throw new IllegalArgumentException("Maximum bytes allowed property must be set to value >= -1");
        }
        this.maxBytes = maxBytes;
    }

    @JsonProperty(value="max-bytes")
    public final long getMaxBytes() {
        return this.maxBytes;
    }

    @JsonIgnore
    public boolean isLimited() {
        return this.getMaxBytes() != -1L && this.getPeriod().getMode() != ResourceLimitsPeriod.PeriodMode.unknown;
    }
}

